/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.NoSuchElementException;
import org.neo4j.collection.PrimitiveLongResourceIterator;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.kernel.impl.index.schema.TokenIndexUpdater;
import org.neo4j.kernel.impl.index.schema.TokenScanKey;
import org.neo4j.kernel.impl.index.schema.TokenScanValue;
import org.neo4j.kernel.impl.index.schema.TokenScanValueIndexAccessor;

class TokenScanValueIterator
extends TokenScanValueIndexAccessor
implements PrimitiveLongResourceIterator {
    public static final long NO_ID = -1L;
    private long fromId;
    private boolean hasNextDecided;
    private boolean hasNext;
    protected long next;

    TokenScanValueIterator(Seeker<TokenScanKey, TokenScanValue> cursor, long fromId) {
        super(cursor);
        this.fromId = fromId;
    }

    public boolean hasNext() {
        if (!this.hasNextDecided) {
            this.hasNext = this.fetchNext();
            this.hasNextDecided = true;
        }
        return this.hasNext;
    }

    public long next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more elements in " + String.valueOf(this));
        }
        this.hasNextDecided = false;
        return this.next;
    }

    protected boolean fetchNext() {
        TokenScanKey key;
        while (true) {
            if (this.bits != 0L) {
                int delta = Long.numberOfTrailingZeros(this.bits);
                this.bits &= this.bits - 1L;
                this.next = this.baseEntityId + (long)delta;
                this.hasNext = true;
                return true;
            }
            try {
                if (!this.cursor.next()) {
                    this.close();
                    return false;
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            key = (TokenScanKey)this.cursor.key();
            this.baseEntityId = key.idRange * 64L;
            this.bits = ((TokenScanValue)this.cursor.value()).bits;
            if (this.fromId == -1L) continue;
            long range = TokenIndexUpdater.rangeOf(this.fromId);
            if (range == key.idRange) {
                long relativeStartId = TokenScanValueIterator.offsetOf(this.fromId);
                long mask = relativeStartId == 63L ? -1L : (1L << (int)(relativeStartId + 1L)) - 1L;
                this.bits &= mask ^ 0xFFFFFFFFFFFFFFFFL;
            }
            this.fromId = -1L;
            assert (this.keysInOrder(key, IndexOrder.ASCENDING));
        }
    }

    private static int offsetOf(long entityId) {
        return (int)(entityId % 64L);
    }
}

