/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.CompositeRangeKey;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.RangeKey;

class RangeLayout
extends IndexLayout<RangeKey> {
    private final int numberOfSlots;

    RangeLayout(int numberOfSlots) {
        super(false, Layout.namedIdentifier((String)"RL", (int)numberOfSlots), 0, 1);
        this.numberOfSlots = numberOfSlots;
    }

    public RangeKey newKey() {
        return this.numberOfSlots == 1 ? new RangeKey() : new CompositeRangeKey(this.numberOfSlots);
    }

    public RangeKey copyKey(RangeKey key, RangeKey into) {
        into.copyFrom(key);
        return into;
    }

    public int keySize(RangeKey key) {
        return key.size();
    }

    public void writeKey(PageCursor cursor, RangeKey key) {
        key.put(cursor);
    }

    public void readKey(PageCursor cursor, RangeKey into, int keySize) {
        into.get(cursor, keySize);
    }

    public void minimalSplitter(RangeKey left, RangeKey right, RangeKey into) {
        right.minimalSplitter(left, right, into);
    }

    public void initializeAsLowest(RangeKey key) {
        key.initValuesAsLowest();
    }

    public void initializeAsHighest(RangeKey key) {
        key.initValuesAsHighest();
    }
}

