/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.constraints.ConstraintDescriptorFactory;
import org.neo4j.internal.schema.constraints.IndexBackedConstraintDescriptor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.exceptions.schema.UniquePropertyValueValidationException;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.TokenIndexReader;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.impl.api.index.AbstractDelegatingIndexProxy;
import org.neo4j.kernel.impl.api.index.FlippableIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.OnlineIndexProxy;
import org.neo4j.kernel.impl.api.index.updater.DelegatingIndexUpdater;
import org.neo4j.kernel.impl.index.schema.DeferredConflictCheckingIndexUpdater;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.NodePropertyAccessor;

public class TentativeConstraintIndexProxy
extends AbstractDelegatingIndexProxy {
    private final FlippableIndexProxy flipper;
    private final OnlineIndexProxy target;
    private final Collection<IndexEntryConflictException> failures = new CopyOnWriteArrayList<IndexEntryConflictException>();
    private TokenNameLookup tokenNameLookup;

    TentativeConstraintIndexProxy(FlippableIndexProxy flipper, OnlineIndexProxy target, TokenNameLookup tokenNameLookup) {
        this.flipper = flipper;
        this.target = target;
        this.tokenNameLookup = tokenNameLookup;
    }

    @Override
    public IndexUpdater newUpdater(IndexUpdateMode mode, CursorContext cursorContext) {
        switch (mode) {
            case ONLINE: {
                return new DelegatingIndexUpdater(new DeferredConflictCheckingIndexUpdater(this.target.accessor.newUpdater(mode, cursorContext), this.target::newValueReader, this.target.getDescriptor(), cursorContext)){

                    @Override
                    public void process(IndexEntryUpdate<?> update) {
                        try {
                            this.delegate.process(update);
                        }
                        catch (IndexEntryConflictException conflict) {
                            TentativeConstraintIndexProxy.this.failures.add(conflict);
                        }
                    }

                    @Override
                    public void close() {
                        try {
                            this.delegate.close();
                        }
                        catch (IndexEntryConflictException conflict) {
                            TentativeConstraintIndexProxy.this.failures.add(conflict);
                        }
                    }
                };
            }
            case RECOVERY: {
                return super.newUpdater(mode, cursorContext);
            }
        }
        throw new IllegalArgumentException("Unsupported update mode: " + String.valueOf(mode));
    }

    @Override
    public InternalIndexState getState() {
        return this.failures.isEmpty() ? InternalIndexState.POPULATING : InternalIndexState.FAILED;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[target:" + String.valueOf(this.target) + "]";
    }

    @Override
    public ValueIndexReader newValueReader() throws IndexNotFoundKernelException {
        throw new IndexNotFoundKernelException(String.valueOf(this.getDescriptor()) + " is still populating");
    }

    @Override
    public TokenIndexReader newTokenReader() {
        throw new UnsupportedOperationException("Not supported for value indexes");
    }

    @Override
    public IndexProxy getDelegate() {
        return this.target;
    }

    @Override
    public void verifyDeferredConstraints(NodePropertyAccessor accessor) throws IndexEntryConflictException, IOException {
        if (!this.failures.isEmpty()) {
            Iterator<IndexEntryConflictException> failureIterator = this.failures.iterator();
            IndexEntryConflictException conflict = failureIterator.next();
            failureIterator.forEachRemaining(conflict::addSuppressed);
            throw conflict;
        }
        super.verifyDeferredConstraints(accessor);
    }

    @Override
    public void validate() throws UniquePropertyValueValidationException {
        if (!this.failures.isEmpty()) {
            SchemaDescriptor descriptor = this.getDescriptor().schema();
            throw new UniquePropertyValueValidationException((IndexBackedConstraintDescriptor)ConstraintDescriptorFactory.uniqueForSchema((SchemaDescriptor)descriptor), ConstraintValidationException.Phase.VERIFICATION, new HashSet<IndexEntryConflictException>(this.failures), this.tokenNameLookup);
        }
    }

    @Override
    public void activate() {
        if (!this.failures.isEmpty()) {
            throw new IllegalStateException("Trying to activate failed index, should have checked the failures earlier...");
        }
        this.flipper.flipTo(this.target);
    }
}

