/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.function.Predicate;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.string.Globbing;
import org.neo4j.token.TokenHolders;

class TokenHoldersIdLookup
implements LoginContext.IdLookup {
    private final TokenHolders tokens;
    private final GlobalProcedures globalProcedures;

    TokenHoldersIdLookup(TokenHolders tokens, GlobalProcedures globalProcedures) {
        this.tokens = tokens;
        this.globalProcedures = globalProcedures;
    }

    public int getPropertyKeyId(String name) {
        return this.tokens.propertyKeyTokens().getIdByName(name);
    }

    public int getLabelId(String name) {
        return this.tokens.labelTokens().getIdByName(name);
    }

    public int getRelTypeId(String name) {
        return this.tokens.relationshipTypeTokens().getIdByName(name);
    }

    public int[] getProcedureIds(String procedureGlobbing) {
        Predicate matcherPredicate = Globbing.globPredicate((String)procedureGlobbing);
        return this.globalProcedures.getIdsOfProceduresMatching(p -> matcherPredicate.test(p.signature().name().toString()));
    }

    public int[] getAdminProcedureIds() {
        return this.globalProcedures.getIdsOfProceduresMatching(p -> p.signature().admin());
    }

    public int[] getFunctionIds(String functionGlobbing) {
        Predicate matcherPredicate = Globbing.globPredicate((String)functionGlobbing);
        return this.globalProcedures.getIdsOfFunctionsMatching(f -> matcherPredicate.test(f.signature().name().toString()));
    }

    public int[] getAggregatingFunctionIds(String functionGlobbing) {
        Predicate matcherPredicate = Globbing.globPredicate((String)functionGlobbing);
        return this.globalProcedures.getIdsOfAggregatingFunctionsMatching(f -> matcherPredicate.test(f.signature().name().toString()));
    }
}

