/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.procedure;

import java.time.Clock;
import java.util.Objects;
import java.util.function.Function;
import org.neo4j.common.DependencyResolver;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.procedure.Context;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.values.ValueMapper;

public class BasicContext
implements Context {
    private final DependencyResolver resolver;
    private final InternalTransaction transaction;
    private final SecurityContext securityContext;
    private final ValueMapper<Object> valueMapper;
    private final Thread thread;
    private final ProcedureCallContext procedureCallContext;

    private BasicContext(DependencyResolver resolver, InternalTransaction transaction, SecurityContext securityContext, ValueMapper<Object> valueMapper, Thread thread, ProcedureCallContext procedureCallContext) {
        this.resolver = resolver;
        this.transaction = transaction;
        this.securityContext = securityContext;
        this.valueMapper = valueMapper;
        this.thread = thread;
        this.procedureCallContext = procedureCallContext;
    }

    @Override
    public ValueMapper<Object> valueMapper() {
        return this.valueMapper;
    }

    @Override
    public SecurityContext securityContext() {
        return this.securityContext;
    }

    @Override
    public DependencyResolver dependencyResolver() {
        return this.resolver;
    }

    @Override
    public GraphDatabaseAPI graphDatabaseAPI() {
        return (GraphDatabaseAPI)this.resolver.resolveDependency(GraphDatabaseAPI.class);
    }

    @Override
    public Thread thread() {
        return this.thread;
    }

    @Override
    public InternalTransaction internalTransaction() throws ProcedureException {
        return (InternalTransaction)BasicContext.throwIfNull("Transaction", this.transaction);
    }

    @Override
    public InternalTransaction internalTransactionOrNull() {
        return this.transaction;
    }

    @Override
    public Clock systemClock() throws ProcedureException {
        return (Clock)BasicContext.throwIfNull("SystemClock", this.transaction.kernelTransaction(), t -> t.clocks().systemClock());
    }

    @Override
    public Clock statementClock() throws ProcedureException {
        return BasicContext.throwIfNull("StatementClock", this.transaction.kernelTransaction(), t -> t.clocks().statementClock());
    }

    @Override
    public Clock transactionClock() throws ProcedureException {
        return BasicContext.throwIfNull("TransactionClock", this.transaction.kernelTransaction(), t -> t.clocks().transactionClock());
    }

    @Override
    public ProcedureCallContext procedureCallContext() {
        return this.procedureCallContext;
    }

    public static ContextBuilder buildContext(DependencyResolver dependencyResolver, ValueMapper<Object> valueMapper) {
        return new ContextBuilder(dependencyResolver, valueMapper);
    }

    private static <T, U> T throwIfNull(String name, U value) throws ProcedureException {
        return (T)BasicContext.throwIfNull(name, value, v -> v);
    }

    private static <T, U> T throwIfNull(String name, U value, Function<U, T> producer) throws ProcedureException {
        if (value == null) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, "There is no `%s` in the current procedure call context.", new Object[]{name});
        }
        return producer.apply(value);
    }

    public static class ContextBuilder {
        private DependencyResolver resolver;
        private InternalTransaction transaction;
        private SecurityContext securityContext = SecurityContext.AUTH_DISABLED;
        private Thread thread = Thread.currentThread();
        private ValueMapper<Object> valueMapper;
        private ProcedureCallContext procedureCallContext;

        private ContextBuilder(DependencyResolver resolver, ValueMapper<Object> valueMapper) {
            this.resolver = resolver;
            this.valueMapper = valueMapper;
        }

        public ContextBuilder withTransaction(InternalTransaction internalTransaction) {
            this.transaction = internalTransaction;
            return this;
        }

        public ContextBuilder withSecurityContext(SecurityContext securityContext) {
            this.securityContext = securityContext;
            return this;
        }

        public ContextBuilder withProcedureCallContext(ProcedureCallContext procedureContext) {
            this.procedureCallContext = procedureContext;
            return this;
        }

        public Context context() {
            Objects.requireNonNull(this.resolver);
            Objects.requireNonNull(this.securityContext);
            Objects.requireNonNull(this.valueMapper);
            Objects.requireNonNull(this.thread);
            return new BasicContext(this.resolver, this.transaction, this.securityContext, this.valueMapper, this.thread, this.procedureCallContext);
        }
    }
}

