/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import java.util.List;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.database.SystemGraphComponent;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintType;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.util.Preconditions;

public abstract class AbstractSystemGraphComponent
implements SystemGraphComponent {
    protected final Config config;

    public AbstractSystemGraphComponent(Config config) {
        this.config = config;
    }

    protected void initializeSystemGraphConstraints(Transaction tx) {
    }

    protected void initializeSystemGraphModel(Transaction tx) throws Exception {
    }

    protected void verifySystemGraph(GraphDatabaseService system) throws Exception {
    }

    private void initializeSystemGraphConstraints(GraphDatabaseService system) {
        try (Transaction tx = system.beginTx();){
            this.initializeSystemGraphConstraints(tx);
            tx.commit();
        }
    }

    protected void initializeSystemGraphModel(GraphDatabaseService system) throws Exception {
        try (Transaction tx = system.beginTx();){
            this.initializeSystemGraphModel(tx);
            tx.commit();
        }
    }

    protected void postInitialization(GraphDatabaseService system, boolean wasInitialized) throws Exception {
    }

    @Override
    public void initializeSystemGraph(GraphDatabaseService system, boolean firstInitialization) throws Exception {
        boolean mayUpgrade = (Boolean)this.config.get(GraphDatabaseSettings.allow_single_automatic_upgrade);
        Preconditions.checkState((boolean)system.databaseName().equals("system"), (String)("Cannot initialize system graph on database '" + system.databaseName() + "'"));
        SystemGraphComponent.Status status = this.detect(system);
        if (status == SystemGraphComponent.Status.UNINITIALIZED) {
            this.initializeSystemGraphConstraints(system);
            this.initializeSystemGraphModel(system);
            this.postInitialization(system, true);
        } else if (status == SystemGraphComponent.Status.CURRENT || status == SystemGraphComponent.Status.REQUIRES_UPGRADE && !mayUpgrade) {
            this.verifySystemGraph(system);
            this.postInitialization(system, false);
        } else if (mayUpgrade && status == SystemGraphComponent.Status.REQUIRES_UPGRADE || status == SystemGraphComponent.Status.UNSUPPORTED_BUT_CAN_UPGRADE) {
            this.upgradeToCurrent(system);
        } else {
            throw new IllegalStateException(String.format("Unsupported component state for '%s': %s", this.componentName(), status.description()));
        }
    }

    protected static void initializeSystemGraphConstraint(Transaction tx, Label label, String property) {
        if (!AbstractSystemGraphComponent.hasUniqueConstraint(tx, label, property)) {
            AbstractSystemGraphComponent.checkForClashingIndexes(tx, label, property);
            tx.schema().constraintFor(label).assertPropertyIsUnique(property).create();
        }
    }

    protected static boolean hasUniqueConstraint(Transaction tx, Label label, String property) {
        return Iterators.stream(tx.schema().getConstraints(label).iterator()).anyMatch(constraintDefinition -> Iterables.asList((Iterable)constraintDefinition.getPropertyKeys()).equals(List.of(property)) && constraintDefinition.isConstraintType(ConstraintType.UNIQUENESS));
    }

    private static void checkForClashingIndexes(Transaction tx, Label label, String property) {
        tx.schema().getIndexes(label).forEach(index -> {
            List propertyKeys = Iterables.asList((Iterable)index.getPropertyKeys());
            if (propertyKeys.size() == 1 && ((String)propertyKeys.get(0)).equals(property)) {
                index.drop();
            }
        });
    }
}

