/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.diffsets;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Predicate;
import org.neo4j.collection.trackable.HeapTrackingCollections;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.kernel.impl.util.diffsets.MutableDiffSets;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;

public class MutableDiffSetsImpl<T>
implements MutableDiffSets<T> {
    private final MemoryTracker memoryTracker;
    private Set<T> addedElements;
    private Set<T> removedElements;
    private Predicate<T> filter;

    private MutableDiffSetsImpl(Set<T> addedElements, Set<T> removedElements, MemoryTracker memoryTracker) {
        this.addedElements = addedElements;
        this.removedElements = removedElements;
        this.memoryTracker = memoryTracker;
    }

    public static <T> MutableDiffSets<T> newMutableDiffSets(MemoryTracker memoryTracker) {
        return new MutableDiffSetsImpl<T>(null, null, memoryTracker);
    }

    @Override
    public boolean add(T elem) {
        boolean wasRemoved = this.removed(false).remove(elem);
        return wasRemoved || this.added(true).add(elem);
    }

    @Override
    public boolean remove(T elem) {
        boolean removedFromAddedElements = this.added(false).remove(elem);
        return removedFromAddedElements || this.removed(true).add(elem);
    }

    @Override
    public boolean unRemove(T item) {
        return this.removed(false).remove(item);
    }

    public String toString() {
        return String.format("{+%s, -%s}", this.added(false), this.removed(false));
    }

    public boolean isAdded(T elem) {
        return this.added(false).contains(elem);
    }

    public boolean isRemoved(T elem) {
        return this.removed(false).contains(elem);
    }

    public Set<T> getAdded() {
        return this.resultSet(this.addedElements);
    }

    public Set<T> getRemoved() {
        return this.resultSet(this.removedElements);
    }

    public boolean isEmpty() {
        return this.added(false).isEmpty() && this.removed(false).isEmpty();
    }

    public Iterator<T> apply(Iterator<? extends T> source) {
        Iterator result = source;
        if (this.removedElements != null && !this.removedElements.isEmpty() || this.addedElements != null && !this.addedElements.isEmpty()) {
            if (this.filter == null) {
                this.filter = item -> !this.removed(false).contains(item) && !this.added(false).contains(item);
            }
            result = Iterators.filter(this.filter, result);
        }
        if (this.addedElements != null && !this.addedElements.isEmpty()) {
            result = Iterators.concat((Iterator[])new Iterator[]{result, this.addedElements.iterator()});
        }
        return result;
    }

    public MutableDiffSetsImpl<T> filterAdded(Predicate<T> addedFilter) {
        return new MutableDiffSetsImpl<T>(Iterables.asSet((Iterable)Iterables.filter(addedFilter, this.added(false))), Iterables.asSet(this.removed(false)), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
    }

    private Set<T> added(boolean create) {
        if (this.addedElements == null) {
            if (!create) {
                return Collections.emptySet();
            }
            this.addedElements = HeapTrackingCollections.newSet((MemoryTracker)this.memoryTracker);
        }
        return this.addedElements;
    }

    private Set<T> removed(boolean create) {
        if (this.removedElements == null) {
            if (!create) {
                return Collections.emptySet();
            }
            this.removedElements = HeapTrackingCollections.newSet((MemoryTracker)this.memoryTracker);
        }
        return this.removedElements;
    }

    private Set<T> resultSet(Set<T> coll) {
        return coll == null ? Collections.emptySet() : Collections.unmodifiableSet(coll);
    }
}

