/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files;

import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointInfo;
import org.neo4j.storageengine.api.StoreId;

public class LogTailInformation {
    public final CheckpointInfo lastCheckPoint;
    public final long firstTxIdAfterLastCheckPoint;
    public final boolean filesNotFound;
    public final long currentLogVersion;
    public final byte latestLogEntryVersion;
    private final boolean recordAfterCheckpoint;
    public final StoreId lastStoreId;

    public LogTailInformation(boolean recordAfterCheckpoint, long firstTxIdAfterLastCheckPoint, boolean filesNotFound, long currentLogVersion, byte latestLogEntryVersion) {
        this(null, recordAfterCheckpoint, firstTxIdAfterLastCheckPoint, filesNotFound, currentLogVersion, latestLogEntryVersion, StoreId.UNKNOWN);
    }

    public LogTailInformation(CheckpointInfo lastCheckPoint, boolean recordAfterCheckpoint, long firstTxIdAfterLastCheckPoint, boolean filesNotFound, long currentLogVersion, byte latestLogEntryVersion, StoreId lastStoreId) {
        this.lastCheckPoint = lastCheckPoint;
        this.firstTxIdAfterLastCheckPoint = firstTxIdAfterLastCheckPoint;
        this.filesNotFound = filesNotFound;
        this.currentLogVersion = currentLogVersion;
        this.latestLogEntryVersion = latestLogEntryVersion;
        this.recordAfterCheckpoint = recordAfterCheckpoint;
        this.lastStoreId = lastStoreId;
    }

    public boolean commitsAfterLastCheckpoint() {
        return this.recordAfterCheckpoint;
    }

    public boolean logsMissing() {
        return this.lastCheckPoint == null && this.filesNotFound;
    }

    public boolean isRecoveryRequired() {
        return this.recordAfterCheckpoint || this.logsMissing();
    }

    public String toString() {
        return "LogTailInformation{lastCheckPoint=" + String.valueOf(this.lastCheckPoint) + ", firstTxIdAfterLastCheckPoint=" + this.firstTxIdAfterLastCheckPoint + ", filesNotFound=" + this.filesNotFound + ", currentLogVersion=" + this.currentLogVersion + ", latestLogEntryVersion=" + this.latestLogEntryVersion + ", recordAfterCheckpoint=" + this.recordAfterCheckpoint + "}";
    }
}

