/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexConfigProvider;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.MinimalIndexAccessor;
import org.neo4j.kernel.impl.api.index.PhaseTracker;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexBase;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexSampler;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexUpdater;
import org.neo4j.kernel.impl.index.schema.fusion.IndexSlot;
import org.neo4j.kernel.impl.index.schema.fusion.InstanceSelector;
import org.neo4j.kernel.impl.index.schema.fusion.LazyInstanceSelector;
import org.neo4j.kernel.impl.index.schema.fusion.SlotSelector;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.values.storable.Value;

class FusionIndexPopulator
extends FusionIndexBase<IndexPopulator>
implements IndexPopulator {
    private final boolean archiveFailedIndex;
    private final IndexFiles indexFiles;

    FusionIndexPopulator(SlotSelector slotSelector, InstanceSelector<IndexPopulator> instanceSelector, IndexFiles indexFiles, boolean archiveFailedIndex) {
        super(slotSelector, instanceSelector);
        this.archiveFailedIndex = archiveFailedIndex;
        this.indexFiles = indexFiles;
    }

    public void create() throws IOException {
        if (this.archiveFailedIndex) {
            this.indexFiles.archiveIndex();
        }
        this.indexFiles.clear();
        this.instanceSelector.forAll(IndexPopulator::create);
    }

    public void drop() {
        this.instanceSelector.forAll(MinimalIndexAccessor::drop);
        this.indexFiles.clear();
    }

    public void add(Collection<? extends IndexEntryUpdate<?>> updates, CursorContext cursorContext) throws IndexEntryConflictException {
        LazyInstanceSelector<Collection> batchSelector = new LazyInstanceSelector<Collection>(slot -> new ArrayList());
        for (IndexEntryUpdate<?> update : updates) {
            batchSelector.select(this.slotSelector.selectSlot(((ValueIndexEntryUpdate)update).values(), CATEGORY_OF)).add(update);
        }
        for (IndexSlot slot2 : IndexSlot.values()) {
            Collection batch = batchSelector.getIfInstantiated(slot2);
            if (batch == null) continue;
            ((IndexPopulator)this.instanceSelector.select(slot2)).add(batch, cursorContext);
        }
    }

    public void verifyDeferredConstraints(NodePropertyAccessor nodePropertyAccessor) throws IndexEntryConflictException {
        for (IndexSlot slot : IndexSlot.values()) {
            ((IndexPopulator)this.instanceSelector.select(slot)).verifyDeferredConstraints(nodePropertyAccessor);
        }
    }

    public IndexUpdater newPopulatingUpdater(NodePropertyAccessor accessor, CursorContext cursorContext) {
        LazyInstanceSelector<IndexUpdater> updaterSelector = new LazyInstanceSelector<IndexUpdater>(slot -> ((IndexPopulator)this.instanceSelector.select((IndexSlot)((Object)slot))).newPopulatingUpdater(accessor, cursorContext));
        return new FusionIndexUpdater(this.slotSelector, updaterSelector);
    }

    public void close(boolean populationCompletedSuccessfully, CursorContext cursorContext) {
        this.instanceSelector.close(populator -> populator.close(populationCompletedSuccessfully, cursorContext));
    }

    public void markAsFailed(String failure) {
        this.instanceSelector.forAll(populator -> populator.markAsFailed(failure));
    }

    public void includeSample(IndexEntryUpdate<?> update) {
        ((IndexPopulator)this.instanceSelector.select(this.slotSelector.selectSlot(((ValueIndexEntryUpdate)update).values(), CATEGORY_OF))).includeSample(update);
    }

    public IndexSample sample(CursorContext cursorContext) {
        return FusionIndexSampler.combineSamples(this.instanceSelector.transform(populator -> populator.sample(cursorContext)));
    }

    public void scanCompleted(PhaseTracker phaseTracker, IndexPopulator.PopulationWorkScheduler populationWorkScheduler, CursorContext cursorContext) throws IndexEntryConflictException {
        this.instanceSelector.throwingForAll(ip -> ip.scanCompleted(phaseTracker, populationWorkScheduler, cursorContext));
    }

    public Map<String, Value> indexConfig() {
        HashMap<String, Value> indexConfig = new HashMap<String, Value>();
        this.instanceSelector.transform(IndexConfigProvider::indexConfig).forEach(source -> IndexConfigProvider.putAllNoOverwrite((Map)indexConfig, (Map)source));
        return indexConfig;
    }
}

