/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.query;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.neo4j.graphdb.ExecutionPlanDescription;
import org.neo4j.graphdb.InputPosition;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.kernel.api.query.CompilerInfo;
import org.neo4j.kernel.api.query.DeprecationNotificationsProvider;
import org.neo4j.kernel.api.query.ExecutingQueryStatus;
import org.neo4j.kernel.api.query.QueryObfuscator;
import org.neo4j.kernel.api.query.QuerySnapshot;
import org.neo4j.kernel.api.query.SimpleState;
import org.neo4j.kernel.api.query.WaitingOnLockEvent;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.lock.ActiveLock;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.LockType;
import org.neo4j.lock.LockWaitEvent;
import org.neo4j.lock.ResourceType;
import org.neo4j.memory.HeapHighWaterMarkTracker;
import org.neo4j.resources.CpuClock;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.values.virtual.MapValue;

public class ExecutingQuery {
    private static final AtomicLongFieldUpdater<ExecutingQuery> WAIT_TIME = AtomicLongFieldUpdater.newUpdater(ExecutingQuery.class, "waitTimeNanos");
    private final long queryId;
    private final LockTracer lockTracer = this::waitForLock;
    private final String executingUsername;
    private final String authenticatedUsername;
    private final ClientConnectionInfo clientConnection;
    private final String rawQueryText;
    private final MapValue rawQueryParameters;
    private final long startTimeNanos;
    private final long startTimestampMillis;
    private final Map<String, Object> transactionAnnotationData;
    private final long threadExecutingTheQueryId;
    private final String threadExecutingTheQueryName;
    private final SystemNanoClock clock;
    private final CpuClock cpuClock;
    private final long cpuTimeNanosWhenQueryStarted;
    private CompilerInfo compilerInfo;
    private long compilationCompletedNanos;
    private String obfuscatedQueryText;
    private Function<InputPosition, InputPosition> obfuscatePostion;
    private MapValue obfuscatedQueryParameters;
    private Supplier<ExecutionPlanDescription> planDescriptionSupplier;
    private DeprecationNotificationsProvider deprecationNotificationsProvider;
    private DeprecationNotificationsProvider fabricDeprecationNotificationsProvider;
    private volatile ExecutingQueryStatus status = SimpleState.parsing();
    private volatile ExecutingQuery previousQuery;
    private volatile long waitTimeNanos;
    private HeapHighWaterMarkTracker memoryTracker;
    private volatile long pageHitsOfClosedTransactions;
    private long pageFaultsOfClosedTransactions;
    private final Queue<TransactionBinding> openTransactionBindings = new ConcurrentLinkedQueue<TransactionBinding>();
    private NamedDatabaseId namedDatabaseId;
    private long outerTransactionId = -1L;

    public ExecutingQuery(long queryId, ClientConnectionInfo clientConnection, String executingUsername, String authenticatedUsername, String queryText, MapValue queryParameters, Map<String, Object> transactionAnnotationData, long threadExecutingTheQueryId, String threadExecutingTheQueryName, SystemNanoClock clock, CpuClock cpuClock, boolean trackQueryAllocations) {
        this.cpuTimeNanosWhenQueryStarted = cpuClock.cpuTimeNanos(threadExecutingTheQueryId);
        this.startTimeNanos = clock.nanos();
        this.startTimestampMillis = clock.millis();
        this.queryId = queryId;
        this.clientConnection = clientConnection;
        this.executingUsername = executingUsername;
        this.authenticatedUsername = authenticatedUsername;
        this.rawQueryText = queryText;
        this.rawQueryParameters = queryParameters;
        this.transactionAnnotationData = transactionAnnotationData;
        this.threadExecutingTheQueryId = threadExecutingTheQueryId;
        this.threadExecutingTheQueryName = threadExecutingTheQueryName;
        this.clock = clock;
        this.cpuClock = cpuClock;
        this.memoryTracker = trackQueryAllocations ? HeapHighWaterMarkTracker.ZERO : HeapHighWaterMarkTracker.NONE;
    }

    public ExecutingQuery(long queryId, ClientConnectionInfo clientConnection, NamedDatabaseId namedDatabaseId, String executingUsername, String authenticatedUsername, String queryText, MapValue queryParameters, Map<String, Object> transactionAnnotationData, LongSupplier activeLockCount, LongSupplier hitsSupplier, LongSupplier faultsSupplier, long threadExecutingTheQueryId, String threadExecutingTheQueryName, SystemNanoClock clock, CpuClock cpuClock, boolean trackQueryAllocations) {
        this(queryId, clientConnection, executingUsername, authenticatedUsername, queryText, queryParameters, transactionAnnotationData, threadExecutingTheQueryId, threadExecutingTheQueryName, clock, cpuClock, trackQueryAllocations);
        this.onTransactionBound(new TransactionBinding(namedDatabaseId, hitsSupplier, faultsSupplier, activeLockCount, 1L));
    }

    public void onTransactionBound(TransactionBinding transactionBinding) {
        if (this.openTransactionBindings.isEmpty()) {
            this.namedDatabaseId = transactionBinding.namedDatabaseId;
            this.outerTransactionId = transactionBinding.transactionId;
        }
        this.openTransactionBindings.add(transactionBinding);
    }

    public void onTransactionUnbound(long userTransactionId) {
        this.openTransactionBindings.stream().filter(binding -> binding.transactionId == userTransactionId).findFirst().ifPresentOrElse(foundBinding -> {
            this.pageFaultsOfClosedTransactions += foundBinding.faultsSupplier.getAsLong();
            this.pageHitsOfClosedTransactions += foundBinding.hitsSupplier.getAsLong();
            this.openTransactionBindings.remove(foundBinding);
        }, () -> {
            throw new IllegalStateException("Unbound a transaction that was never bound. ID: " + userTransactionId);
        });
    }

    public void onObfuscatorReady(QueryObfuscator queryObfuscator) {
        this.onObfuscatorReady(queryObfuscator, 0);
    }

    public void onObfuscatorReady(QueryObfuscator queryObfuscator, int preparserOffset) {
        if (this.status != SimpleState.parsing()) {
            return;
        }
        try {
            this.obfuscatedQueryText = queryObfuscator.obfuscateText(this.rawQueryText, preparserOffset);
            this.obfuscatePostion = queryObfuscator.obfuscatePosition(this.rawQueryText, preparserOffset);
            this.obfuscatedQueryParameters = queryObfuscator.obfuscateParameters(this.rawQueryParameters);
        }
        catch (Exception ignore) {
            this.obfuscatedQueryText = null;
            this.obfuscatePostion = null;
            this.obfuscatedQueryParameters = null;
        }
        this.status = SimpleState.planning();
    }

    public void onFabricDeprecationNotificationsProviderReady(DeprecationNotificationsProvider deprecationNotificationsProvider) {
        this.fabricDeprecationNotificationsProvider = deprecationNotificationsProvider;
    }

    public void onCompilationCompleted(CompilerInfo compilerInfo, Supplier<ExecutionPlanDescription> planDescriptionSupplier, DeprecationNotificationsProvider deprecationNotificationsProvider) {
        this.assertExpectedStatus(SimpleState.planning());
        this.compilerInfo = compilerInfo;
        this.compilationCompletedNanos = this.clock.nanos();
        this.planDescriptionSupplier = planDescriptionSupplier;
        this.deprecationNotificationsProvider = deprecationNotificationsProvider;
        this.status = SimpleState.planned();
    }

    public void onExecutionStarted(HeapHighWaterMarkTracker memoryTracker) {
        this.assertExpectedStatus(SimpleState.planned());
        this.memoryTracker = memoryTracker;
        this.status = SimpleState.running();
    }

    public void onRetryAttempted() {
        this.assertExpectedStatus(SimpleState.running());
        this.compilerInfo = null;
        this.compilationCompletedNanos = 0L;
        this.planDescriptionSupplier = null;
        this.deprecationNotificationsProvider = null;
        this.fabricDeprecationNotificationsProvider = null;
        this.memoryTracker = HeapHighWaterMarkTracker.NONE;
        this.obfuscatedQueryParameters = null;
        this.obfuscatePostion = null;
        this.obfuscatedQueryText = null;
        this.status = SimpleState.parsing();
    }

    public LockTracer lockTracer() {
        return this.lockTracer;
    }

    public QuerySnapshot snapshot() {
        MapValue queryParameters;
        Function<InputPosition, InputPosition> queryPostions;
        String queryText;
        long currentTimeNanos;
        long cpuTimeNanos;
        ExecutingQueryStatus status;
        do {
            status = this.status;
            long waitTimeNanos = this.waitTimeNanos;
            cpuTimeNanos = this.cpuClock.cpuTimeNanos(this.threadExecutingTheQueryId);
            currentTimeNanos = this.clock.nanos();
            queryText = this.obfuscatedQueryText;
            queryPostions = this.obfuscatePostion;
            queryParameters = this.obfuscatedQueryParameters;
        } while (this.status != status);
        long compilationCompletedNanos = this.compilationCompletedNanos;
        CompilerInfo planner = status.isParsingOrPlanning() ? null : this.compilerInfo;
        List<ActiveLock> waitingOnLocks = status.isWaitingOnLocks() ? status.waitingOnLocks() : Collections.emptyList();
        long activeLocks = 0L;
        long hits = this.pageHitsOfClosedTransactions;
        long faults = this.pageFaultsOfClosedTransactions;
        for (TransactionBinding tx : this.openTransactionBindings) {
            activeLocks += tx.getActiveLocks();
            hits += tx.hitsSupplier.getAsLong();
            faults += tx.faultsSupplier.getAsLong();
        }
        long compilationTimeNanos = (status.isParsingOrPlanning() ? currentTimeNanos : compilationCompletedNanos) - this.startTimeNanos;
        long elapsedTimeNanos = currentTimeNanos - this.startTimeNanos;
        return new QuerySnapshot(this, planner, hits, faults, TimeUnit.NANOSECONDS.toMicros(compilationTimeNanos), TimeUnit.NANOSECONDS.toMicros(elapsedTimeNanos), (cpuTimeNanos -= this.cpuTimeNanosWhenQueryStarted) == 0L && this.cpuTimeNanosWhenQueryStarted == -1L ? -1L : TimeUnit.NANOSECONDS.toMicros(cpuTimeNanos), TimeUnit.NANOSECONDS.toMicros(waitTimeNanos += status.waitTimeNanos(currentTimeNanos)), status.name(), status.toMap(currentTimeNanos), waitingOnLocks, activeLocks, this.memoryTracker.heapHighWaterMark(), Optional.ofNullable(queryText), Optional.ofNullable(queryPostions), Optional.ofNullable(queryParameters), this.outerTransactionId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecutingQuery that = (ExecutingQuery)o;
        return this.queryId == that.queryId;
    }

    public int hashCode() {
        return (int)(this.queryId ^ this.queryId >>> 32);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public long internalQueryId() {
        return this.queryId;
    }

    public String id() {
        return Long.toString(this.internalQueryId());
    }

    public String executingUsername() {
        return this.executingUsername;
    }

    public String authenticatedUsername() {
        return this.authenticatedUsername;
    }

    public String rawQueryText() {
        return this.rawQueryText;
    }

    public MapValue rawQueryParameters() {
        return this.rawQueryParameters;
    }

    Supplier<ExecutionPlanDescription> planDescriptionSupplier() {
        return this.planDescriptionSupplier;
    }

    public DeprecationNotificationsProvider getDeprecationNotificationsProvider() {
        return this.deprecationNotificationsProvider;
    }

    public DeprecationNotificationsProvider getFabricDeprecationNotificationsProvider() {
        return this.fabricDeprecationNotificationsProvider;
    }

    public Optional<NamedDatabaseId> databaseId() {
        return Optional.ofNullable(this.namedDatabaseId);
    }

    public long startTimestampMillis() {
        return this.startTimestampMillis;
    }

    public long elapsedNanos() {
        return this.clock.nanos() - this.startTimeNanos;
    }

    public long elapsedMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.elapsedNanos());
    }

    public Map<String, Object> transactionAnnotationData() {
        return this.transactionAnnotationData;
    }

    public long reportedWaitingTimeNanos() {
        return this.waitTimeNanos;
    }

    public long totalWaitingTimeNanos(long currentTimeNanos) {
        return this.waitTimeNanos + this.status.waitTimeNanos(currentTimeNanos);
    }

    public String threadExecutingTheQueryName() {
        return this.threadExecutingTheQueryName;
    }

    ClientConnectionInfo clientConnection() {
        return this.clientConnection;
    }

    private LockWaitEvent waitForLock(LockType lockType, ResourceType resourceType, long userTransactionId, long[] resourceIds) {
        WaitingOnLockEvent event = new WaitingOnLockEvent(lockType, resourceType, userTransactionId, resourceIds, this, this.clock.nanos(), this.status);
        this.status = event;
        return event;
    }

    void doneWaitingOnLock(WaitingOnLockEvent waiting) {
        if (this.status != waiting) {
            return;
        }
        WAIT_TIME.addAndGet(this, waiting.waitTimeNanos(this.clock.nanos()));
        this.status = waiting.previousStatus();
    }

    private void assertExpectedStatus(ExecutingQueryStatus expectedStatus) {
        if (this.status != expectedStatus) {
            throw new IllegalStateException(String.format("Expected query in '%s' state, actual state is '%s'.", expectedStatus.name(), this.status.name()));
        }
    }

    public ExecutingQuery getPreviousQuery() {
        return this.previousQuery;
    }

    public void setPreviousQuery(ExecutingQuery previousQuery) {
        this.previousQuery = previousQuery;
    }

    public long pageHitsOfClosedTransactions() {
        return this.pageHitsOfClosedTransactions;
    }

    public long pageFaultsOfClosedTransactions() {
        return this.pageFaultsOfClosedTransactions;
    }

    public static class TransactionBinding {
        private final NamedDatabaseId namedDatabaseId;
        private final LongSupplier hitsSupplier;
        private final LongSupplier faultsSupplier;
        private final LongSupplier activeLockCount;
        private final long initialActiveLocks;
        private final long transactionId;

        public TransactionBinding(NamedDatabaseId namedDatabaseId, LongSupplier hitsSupplier, LongSupplier faultsSupplier, LongSupplier activeLockCount, long transactionId) {
            this.namedDatabaseId = namedDatabaseId;
            this.hitsSupplier = hitsSupplier;
            this.faultsSupplier = faultsSupplier;
            this.activeLockCount = activeLockCount;
            this.initialActiveLocks = activeLockCount.getAsLong();
            this.transactionId = transactionId;
        }

        public long getActiveLocks() {
            return this.activeLockCount.getAsLong() - this.initialActiveLocks;
        }
    }
}

