/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.security;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.security.URLAccessRule;
import org.neo4j.graphdb.security.URLAccessValidationError;

class FileURLAccessRule
implements URLAccessRule {
    FileURLAccessRule() {
    }

    public URL validate(Configuration config, URL url) throws URLAccessValidationError {
        if (url.getAuthority() != null && !url.getAuthority().equals("")) {
            throw new URLAccessValidationError("file URL may not contain an authority section (i.e. it should be 'file:///')");
        }
        if (url.getQuery() != null && !url.getQuery().equals("")) {
            throw new URLAccessValidationError("file URL may not contain a query component");
        }
        if (!((Boolean)config.get(GraphDatabaseSettings.allow_file_urls)).booleanValue()) {
            throw new URLAccessValidationError("configuration property '" + GraphDatabaseSettings.allow_file_urls.name() + "' is false");
        }
        if (!((Config)config).isExplicitlySet(GraphDatabaseSettings.load_csv_file_url_root)) {
            return url;
        }
        Path root = (Path)config.get(GraphDatabaseSettings.load_csv_file_url_root);
        try {
            Path urlPath = Path.of(url.toURI().normalize());
            Path rootPath = root.normalize().toAbsolutePath();
            Path result = rootPath.resolve(urlPath.getRoot().relativize(urlPath)).normalize().toAbsolutePath();
            if (result.startsWith(rootPath)) {
                return result.toUri().toURL();
            }
            throw new URLAccessValidationError("file URL points outside configured import directory");
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

