/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.systemgraph;

import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.systemgraph.DriverSettings;
import org.neo4j.dbms.systemgraph.ExternalDatabaseCredentials;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.database.NamedDatabaseId;

public interface TopologyGraphDbmsModel {
    public static final Label DATABASE_LABEL = Label.label((String)"Database");
    public static final String DATABASE = DATABASE_LABEL.name();
    public static final Label DELETED_DATABASE_LABEL = Label.label((String)"DeletedDatabase");
    public static final String DATABASE_UUID_PROPERTY = "uuid";
    public static final String DATABASE_NAME_PROPERTY = "name";
    public static final String DATABASE_STATUS_PROPERTY = "status";
    public static final String DATABASE_ACCESS_PROPERTY = "access";
    public static final String DATABASE_DEFAULT_PROPERTY = "default";
    public static final String DATABASE_UPDATE_ID_PROPERTY = "update_id";
    public static final String DATABASE_INITIAL_SERVERS_PROPERTY = "initial_members";
    public static final String DATABASE_STORE_CREATION_TIME_PROPERTY = "store_creation_time";
    public static final String DATABASE_STORE_RANDOM_ID_PROPERTY = "store_random_id";
    public static final String DATABASE_STORE_VERSION_PROPERTY = "store_version";
    public static final String DATABASE_DESIGNATED_SEEDER_PROPERTY = "designated_seeder";
    public static final String DATABASE_STORAGE_ENGINE_PROPERTY = "storage_engine";
    public static final String DATABASE_PRIMARIES_PROPERTY = "primaries";
    public static final String DATABASE_SECONDARIES_PROPERTY = "secondaries";
    public static final String DATABASE_CREATED_AT_PROPERTY = "created_at";
    public static final String DATABASE_STARTED_AT_PROPERTY = "started_at";
    public static final String DATABASE_UPDATED_AT_PROPERTY = "updated_at";
    public static final String DATABASE_STOPPED_AT_PROPERTY = "stopped_at";
    public static final String DELETED_DATABASE_DUMP_DATA_PROPERTY = "dump_data";
    public static final String DELETED_DATABASE_DELETED_AT_PROPERTY = "deleted_at";
    public static final Label DATABASE_NAME_LABEL = Label.label((String)"DatabaseName");
    public static final String DATABASE_NAME = DATABASE_NAME_LABEL.name();
    public static final String DATABASE_NAME_LABEL_DESCRIPTION = "Database alias";
    public static final String NAME_PROPERTY = "name";
    public static final String VERSION_PROPERTY = "version";
    public static final RelationshipType TARGETS_RELATIONSHIP = RelationshipType.withName((String)"TARGETS");
    public static final String TARGETS = TARGETS_RELATIONSHIP.name();
    public static final String TARGET_NAME_PROPERTY = "target_name";
    public static final String PRIMARY_PROPERTY = "primary";
    public static final Label REMOTE_DATABASE_LABEL = Label.label((String)"Remote");
    public static final String REMOTE_DATABASE = REMOTE_DATABASE_LABEL.name();
    public static final String REMOTE_DATABASE_LABEL_DESCRIPTION = "Remote Database alias";
    public static final String URL_PROPERTY = "url";
    public static final String USERNAME_PROPERTY = "username";
    public static final String PASSWORD_PROPERTY = "password";
    public static final String IV_PROPERTY = "iv";
    public static final Label DRIVER_SETTINGS_LABEL = Label.label((String)"DriverSettings");
    public static final String DRIVER_SETTINGS = DRIVER_SETTINGS_LABEL.name();
    public static final String SSL_ENFORCED = "ssl_enforced";
    public static final String CONNECTION_TIMEOUT = "connection_timeout";
    public static final String CONNECTION_MAX_LIFETIME = "connection_max_lifetime";
    public static final String CONNECTION_POOL_AQUISITION_TIMEOUT = "connection_pool_acquisition_timeout";
    public static final String CONNECTION_POOL_IDLE_TEST = "connection_pool_idle_test";
    public static final String CONNECTION_POOL_MAX_SIZE = "connection_pool_max_size";
    public static final String LOGGING_LEVEL = "logging_level";
    public static final RelationshipType CONNECTS_WITH_RELATIONSHIP = RelationshipType.withName((String)"CONNECTS_WITH");
    public static final String CONNECTS_WITH = CONNECTS_WITH_RELATIONSHIP.name();
    public static final Label INSTANCE_LABEL = Label.label((String)"Instance");
    public static final Label REMOVED_INSTANCE_LABEL = Label.label((String)"RemovedInstance");
    public static final String INSTANCE_UUID_PROPERTY = "uuid";
    public static final String INSTANCE_STATUS_PROPERTY = "status";
    public static final String INSTANCE_DISCOVERED_AT_PROPERTY = "discovered_at";
    public static final String INSTANCE_MODE_PROPERTY = "mode";
    public static final String REMOVED_INSTANCE_REMOVED_AT_PROPERTY = "removed_at";
    public static final String REMOVED_INSTANCE_ALIASES_PROPERTY = "aliases";
    public static final RelationshipType HOSTED_ON_RELATIONSHIP = RelationshipType.withName((String)"HOSTED_ON");
    public static final RelationshipType WAS_HOSTED_ON_RELATIONSHIP = RelationshipType.withName((String)"WAS_HOSTED_ON");
    public static final String HOSTED_ON_INSTALLED_AT_PROPERTY = "installed_at";
    public static final String HOSTED_ON_BOOTSTRAPPER_PROPERTY = "bootstrapper";
    public static final String HOSTED_ON_MODE_PROPERTY = "mode";
    public static final String WAS_HOSTED_ON_REMOVED_AT_PROPERTY = "removed_at";
    public static final Label TOPOLOGY_GRAPH_SETTINGS_LABEL = Label.label((String)"TopologyGraphSettings");
    public static final String TOPOLOGY_GRAPH_SETTINGS_ALLOCATOR_PROPERTY = "allocator";

    public Set<NamedDatabaseId> getAllDatabaseIds();

    public Optional<NamedDatabaseId> getDatabaseIdByAlias(String var1);

    public Optional<NamedDatabaseId> getDatabaseIdByUUID(UUID var1);

    public Set<DatabaseReference> getAllDatabaseReferences();

    public Set<DatabaseReference.Internal> getAllInternalDatabaseReferences();

    public Set<DatabaseReference.External> getAllExternalDatabaseReferences();

    public Optional<DatabaseReference> getDatabaseRefByAlias(String var1);

    public Optional<DriverSettings> getDriverSettings(String var1);

    public Optional<ExternalDatabaseCredentials> getExternalDatabaseCredentials(String var1);

    public static enum InstanceStatus {
        active,
        draining;

    }

    public static enum DatabaseAccess {
        READ_ONLY("read-only"),
        READ_WRITE("read-write");

        private final String stringRepr;

        private DatabaseAccess(String stringRepr) {
            this.stringRepr = stringRepr;
        }

        public String getStringRepr() {
            return this.stringRepr;
        }
    }

    public static enum DatabaseStatus {
        online,
        offline;

    }

    public static enum HostedOnMode {
        raft(GraphDatabaseSettings.Mode.CORE),
        replica(GraphDatabaseSettings.Mode.READ_REPLICA),
        single(GraphDatabaseSettings.Mode.SINGLE);

        private final GraphDatabaseSettings.Mode instanceMode;

        private HostedOnMode(GraphDatabaseSettings.Mode instanceMode) {
            this.instanceMode = instanceMode;
        }

        public GraphDatabaseSettings.Mode instanceMode() {
            return this.instanceMode;
        }

        public static HostedOnMode from(GraphDatabaseSettings.Mode instanceMode) {
            for (HostedOnMode mode : HostedOnMode.values()) {
                if (mode.instanceMode != instanceMode) continue;
                return mode;
            }
            throw new IllegalArgumentException("Invalid instance mode found: " + String.valueOf(instanceMode));
        }
    }
}

