/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files;

import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.internal.nativeimpl.NativeAccess;
import org.neo4j.internal.nativeimpl.NativeCallResult;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.transaction.log.files.ChannelNativeAccessor;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesContext;
import org.neo4j.logging.Log;

public class LogFileChannelNativeAccessor
implements ChannelNativeAccessor {
    private final FileSystemAbstraction fileSystem;
    private final NativeAccess nativeAccess;
    private final Log log;
    private final AtomicLong rotationThreshold;
    private final Config config;
    private final String databaseName;

    public LogFileChannelNativeAccessor(FileSystemAbstraction fileSystem, TransactionLogFilesContext context) {
        this.fileSystem = fileSystem;
        this.nativeAccess = context.getNativeAccess();
        this.log = context.getLogProvider().getLog(this.getClass());
        this.rotationThreshold = context.getRotationThreshold();
        this.config = context.getConfig();
        this.databaseName = context.getDatabaseName();
    }

    @Override
    public void adviseSequentialAccessAndKeepInCache(StoreChannel channel, long version) {
        if (channel.isOpen()) {
            NativeCallResult cacheResult;
            int fileDescriptor = this.fileSystem.getFileDescriptor(channel);
            NativeCallResult sequentialResult = this.nativeAccess.tryAdviseSequentialAccess(fileDescriptor);
            if (sequentialResult.isError()) {
                this.log.warn("Unable to advise sequential access for transaction log version: " + version + ". Error: " + String.valueOf(sequentialResult));
            }
            if ((cacheResult = this.nativeAccess.tryAdviseToKeepInCache(fileDescriptor)).isError()) {
                this.log.warn("Unable to advise preserve data in cache for transaction log version: " + version + ". Error: " + String.valueOf(cacheResult));
            }
        }
    }

    @Override
    public void evictFromSystemCache(StoreChannel channel, long version) {
        NativeCallResult result;
        if (channel.isOpen() && (result = this.nativeAccess.tryEvictFromCache(this.fileSystem.getFileDescriptor(channel))).isError()) {
            this.log.warn("Unable to evict transaction log from cache with version: " + version + ". Error: " + String.valueOf(result));
        }
    }

    @Override
    public void preallocateSpace(StoreChannel storeChannel, long version) {
        int fileDescriptor = this.fileSystem.getFileDescriptor(storeChannel);
        NativeCallResult result = this.nativeAccess.tryPreallocateSpace(fileDescriptor, this.rotationThreshold.get());
        if (result.isError()) {
            if (this.nativeAccess.errorTranslator().isOutOfDiskSpace(result)) {
                this.handleOutOfDiskSpaceError(result);
            } else {
                this.log.warn("Error on attempt to preallocate log file version: " + version + ". Error: " + String.valueOf(result));
            }
        }
    }

    private void handleOutOfDiskSpaceError(NativeCallResult result) {
        this.log.error("Warning! System is running out of disk space. Failed to preallocate log file since disk does not have enough space left. Please provision more space to avoid that. Allocation failure details: " + String.valueOf(result));
        if (((Boolean)this.config.get(GraphDatabaseInternalSettings.dynamic_read_only_failover)).booleanValue()) {
            this.log.error("Switching database to read only mode.");
            this.markDatabaseReadOnly();
        } else {
            this.log.error("Dynamic switchover to read-only mode is disabled. The database will continue execution in the current mode.");
        }
    }

    private void markDatabaseReadOnly() {
        HashSet<String> readOnlyDatabases = new HashSet<String>((Collection)this.config.get(GraphDatabaseSettings.read_only_databases));
        readOnlyDatabases.add(this.databaseName);
        this.config.setDynamic(GraphDatabaseSettings.read_only_databases, readOnlyDatabases, "Dynamic failover to read-only mode.");
    }
}

