/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery.facade;

import java.io.IOException;
import org.neo4j.configuration.Config;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.database.DatabaseTracers;
import org.neo4j.kernel.recovery.Recovery;
import org.neo4j.kernel.recovery.facade.RecoveryCriteria;
import org.neo4j.kernel.recovery.facade.RecoveryFacade;
import org.neo4j.kernel.recovery.facade.RecoveryFacadeMonitor;
import org.neo4j.logging.LogProvider;
import org.neo4j.memory.MemoryTracker;

public class DatabaseRecoveryFacade
implements RecoveryFacade {
    private final FileSystemAbstraction fs;
    private final PageCache pageCache;
    private final DatabaseTracers tracers;
    private final Config config;
    private final MemoryTracker memoryTracker;
    private final LogProvider logProvider;

    public DatabaseRecoveryFacade(FileSystemAbstraction fs, PageCache pageCache, DatabaseTracers tracers, Config config, MemoryTracker memoryTracker, LogProvider logProvider) {
        this.fs = fs;
        this.pageCache = pageCache;
        this.tracers = tracers;
        this.config = config;
        this.memoryTracker = memoryTracker;
        this.logProvider = logProvider;
    }

    @Override
    public void performRecovery(DatabaseLayout databaseLayout) throws IOException {
        this.performRecovery(databaseLayout, RecoveryFacadeMonitor.EMPTY_MONITOR);
    }

    @Override
    public void performRecovery(DatabaseLayout databaseLayout, RecoveryFacadeMonitor monitor) throws IOException {
        this.performRecovery(databaseLayout, RecoveryCriteria.ALL, monitor);
    }

    @Override
    public void performRecovery(DatabaseLayout databaseLayout, RecoveryCriteria recoveryCriteria, RecoveryFacadeMonitor monitor) throws IOException {
        monitor.recoveryStarted();
        Recovery.performRecovery(this.fs, this.pageCache, this.tracers, this.config, databaseLayout, this.memoryTracker, this.logProvider, recoveryCriteria);
        monitor.recoveryCompleted();
    }
}

