/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.Arrays;
import java.util.StringJoiner;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.BtreeKey;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.PointKeyUtil;
import org.neo4j.kernel.impl.index.schema.Type;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.Values;

class GeometryType
extends Type {
    GeometryType(byte typeId) {
        super(ValueGroup.GEOMETRY, typeId, (Value)PointValue.MIN_VALUE, (Value)PointValue.MAX_VALUE);
    }

    @Override
    int valueSize(GenericKey<?> state) {
        int coordinatesSize = GeometryType.dimensions(state) * 8;
        return 11 + coordinatesSize;
    }

    static int dimensions(GenericKey<?> state) {
        return Math.toIntExact(state.long3);
    }

    @Override
    void copyValue(GenericKey<?> to, GenericKey<?> from) {
        to.long0 = from.long0;
        to.long1 = from.long1;
        to.long2 = from.long2;
        to.long3 = from.long3;
        int dimensions = GeometryType.dimensions(from);
        to.long1Array = GeometryType.ensureBigEnough(to.long1Array, dimensions);
        System.arraycopy(from.long1Array, 0, to.long1Array, 0, dimensions);
        to.spaceFillingCurve = from.spaceFillingCurve;
    }

    @Override
    Value asValue(GenericKey<?> state) {
        GeometryType.assertHasCoordinates(state);
        CoordinateReferenceSystem crs = CoordinateReferenceSystem.get((int)((int)state.long1), (int)((int)state.long2));
        return GeometryType.asValue(state, crs, 0);
    }

    static PointValue asValue(GenericKey<?> state, CoordinateReferenceSystem crs, int offset) {
        double[] coordinates = new double[GeometryType.dimensions(state)];
        for (int i = 0; i < coordinates.length; ++i) {
            coordinates[i] = Double.longBitsToDouble(state.long1Array[offset + i]);
        }
        return Values.pointValue((CoordinateReferenceSystem)crs, (double[])coordinates);
    }

    @Override
    int compareValue(GenericKey<?> left, GenericKey<?> right) {
        return GeometryType.compare(left.long0, left.long1, left.long2, left.long3, left.long1Array, 0, right.long0, right.long1, right.long2, right.long3, right.long1Array, 0);
    }

    @Override
    void putValue(PageCursor cursor, GenericKey<?> state) {
        GeometryType.putCrs(cursor, state.long1, state.long2, state.long3);
        GeometryType.putPoint(cursor, state.long0, state.long3, state.long1Array, 0);
    }

    @Override
    boolean readValue(PageCursor cursor, int size, GenericKey<?> into) {
        return GeometryType.readCrs(cursor, into) && GeometryType.readPoint(cursor, into);
    }

    @Override
    String toString(GenericKey<?> state) {
        String asValueString = GeometryType.hasCoordinates(state) ? this.asValue(state).toString() : "NO_COORDINATES";
        return String.format("Geometry[tableId:%d, code:%d, rawValue:%d, value:%s", state.long1, state.long2, state.long0, asValueString);
    }

    static int compare(long this_long0, long this_long1, long this_long2, long this_long3, long[] this_long1Array, int this_coordinates_offset, long that_long0, long that_long1, long that_long2, long that_long3, long[] that_long1Array, int that_coordinates_offset) {
        int tableIdComparison = Integer.compare((int)this_long1, (int)that_long1);
        if (tableIdComparison != 0) {
            return tableIdComparison;
        }
        int codeComparison = Integer.compare((int)this_long2, (int)that_long2);
        if (codeComparison != 0) {
            return codeComparison;
        }
        int derivedValueComparison = Long.compare(this_long0, that_long0);
        if (derivedValueComparison != 0) {
            return derivedValueComparison;
        }
        long dimensions = Math.min(this_long3, that_long3);
        int i = 0;
        while ((long)i < dimensions) {
            int coordinateComparison = Long.compare(this_long1Array[this_coordinates_offset + i], that_long1Array[that_coordinates_offset + i]);
            if (coordinateComparison != 0) {
                return coordinateComparison;
            }
            ++i;
        }
        return 0;
    }

    static void putCrs(PageCursor cursor, long long1, long long2, long long3) {
        PointKeyUtil.writeHeader(cursor, long1, long2, long3);
    }

    static void putPoint(PageCursor cursor, long long0, long long3, long[] long1Array, int long1ArrayOffset) {
        cursor.putLong(long0);
        int i = 0;
        while ((long)i < long3) {
            cursor.putLong(long1Array[long1ArrayOffset + i]);
            ++i;
        }
    }

    static void assertHasCoordinates(GenericKey<?> state) {
        if (!GeometryType.hasCoordinates(state)) {
            throw new IllegalStateException("This geometry key doesn't have coordinates and can therefore neither be persisted nor generate point value.");
        }
    }

    static boolean hasCoordinates(GenericKey<?> state) {
        return state.long3 != 0L && state.long1Array != null;
    }

    static void setNoCoordinates(GenericKey<?> state) {
        state.long3 = 0L;
    }

    static boolean readCrs(PageCursor cursor, GenericKey<?> into) {
        int header = PointKeyUtil.readHeader(cursor);
        into.long1 = PointKeyUtil.crsTableId(header);
        into.long2 = PointKeyUtil.crsCode(header);
        into.long3 = PointKeyUtil.dimensions(header);
        return true;
    }

    private static boolean readPoint(PageCursor cursor, GenericKey<?> into) {
        into.long0 = cursor.getLong();
        int dimensions = GeometryType.dimensions(into);
        into.long1Array = GeometryType.ensureBigEnough(into.long1Array, dimensions);
        for (int i = 0; i < dimensions; ++i) {
            into.long1Array[i] = cursor.getLong();
        }
        return true;
    }

    static void write(BtreeKey state, long derivedSpaceFillingCurveValue, double[] coordinate) {
        state.long0 = derivedSpaceFillingCurveValue;
        state.long1Array = GeometryType.ensureBigEnough(state.long1Array, coordinate.length);
        for (int i = 0; i < coordinate.length; ++i) {
            state.long1Array[i] = Double.doubleToLongBits(coordinate[i]);
        }
        state.long3 = coordinate.length;
    }

    @Override
    protected void addTypeSpecificDetails(StringJoiner joiner, GenericKey<?> state) {
        joiner.add("long0=" + state.long0);
        joiner.add("long1=" + state.long1);
        joiner.add("long2=" + state.long2);
        joiner.add("long3=" + state.long3);
        joiner.add("long1Array=" + Arrays.toString(state.long1Array));
    }
}

