/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.scheduler;

import java.time.Duration;
import java.time.Instant;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.kernel.impl.scheduler.FailedJobRunsStore;
import org.neo4j.kernel.impl.scheduler.ThreadPoolManager;
import org.neo4j.kernel.impl.scheduler.TimeBasedTaskScheduler;
import org.neo4j.scheduler.CancelListener;
import org.neo4j.scheduler.FailedJobRun;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobMonitoringParams;
import org.neo4j.scheduler.JobType;
import org.neo4j.scheduler.MonitoredJobInfo;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.util.concurrent.BinaryLatch;

final class ScheduledJobHandle<T>
implements JobHandle<T> {
    private static final int RUNNABLE = 0;
    private static final int SUBMITTED = 1;
    private static final int EXECUTING = 2;
    private static final int FAILED = 3;
    long nextDeadlineNanos;
    private final AtomicInteger state;
    private final TimeBasedTaskScheduler scheduler;
    private final Group group;
    private final CopyOnWriteArrayList<CancelListener> cancelListeners;
    private final BinaryLatch handleRelease;
    private final Runnable task;
    private final JobMonitoringParams jobMonitoringParams;
    private final long submittedMillis;
    private final long reschedulingDelayNanos;
    private final Set<ScheduledJobHandle<?>> monitoredJobs;
    private final FailedJobRunsStore failedJobRunsStore;
    private final long jobId;
    private volatile JobHandle latestHandle;
    private volatile Throwable lastException;

    ScheduledJobHandle(TimeBasedTaskScheduler scheduler, Group group, Runnable task, long nextDeadlineNanos, long reschedulingDelayNanos, JobMonitoringParams jobMonitoringParams, long submittedMillis, Set<ScheduledJobHandle<?>> monitoredJobs, FailedJobRunsStore failedJobRunsStore, SystemNanoClock clock, long jobId) {
        this.jobMonitoringParams = jobMonitoringParams;
        this.submittedMillis = submittedMillis;
        this.state = new AtomicInteger();
        this.scheduler = scheduler;
        this.group = group;
        this.nextDeadlineNanos = nextDeadlineNanos;
        this.reschedulingDelayNanos = reschedulingDelayNanos;
        this.monitoredJobs = monitoredJobs;
        this.failedJobRunsStore = failedJobRunsStore;
        this.jobId = jobId;
        this.handleRelease = new BinaryLatch();
        this.cancelListeners = new CopyOnWriteArrayList();
        boolean isRecurring = reschedulingDelayNanos > 0L;
        this.task = () -> {
            Instant executionStart = clock.instant();
            try {
                if (this.state.compareAndSet(1, 2)) {
                    task.run();
                }
                this.lastException = null;
            }
            catch (Throwable e) {
                this.lastException = e;
                if (!isRecurring) {
                    this.state.set(3);
                }
                this.recordFailedRun(executionStart, clock.instant(), e);
            }
            finally {
                if (this.state.compareAndSet(2, 0) && isRecurring) {
                    this.nextDeadlineNanos += reschedulingDelayNanos;
                    scheduler.enqueueTask(this);
                } else {
                    monitoredJobs.remove(this);
                }
            }
        };
    }

    void submitIfRunnable(ThreadPoolManager pools) {
        if (this.state.compareAndSet(0, 1)) {
            this.latestHandle = pools.getThreadPool(this.group).submit(JobMonitoringParams.NOT_MONITORED, this.task);
            this.handleRelease.release();
        }
    }

    public void cancel() {
        this.monitoredJobs.remove(this);
        this.state.set(3);
        JobHandle handle = this.latestHandle;
        if (handle != null) {
            handle.cancel();
        }
        for (CancelListener cancelListener : this.cancelListeners) {
            cancelListener.cancelled();
        }
        this.scheduler.cancelTask(this);
        this.handleRelease.release();
    }

    public void waitTermination() throws ExecutionException, InterruptedException {
        this.handleRelease.await();
        RuntimeException runtimeException = null;
        try {
            JobHandle handleDelegate = this.latestHandle;
            if (handleDelegate != null) {
                handleDelegate.waitTermination();
            }
        }
        catch (RuntimeException t) {
            runtimeException = t;
        }
        if (this.state.get() == 3) {
            Throwable exception = this.lastException;
            if (exception != null) {
                ExecutionException executionException = new ExecutionException(exception);
                if (runtimeException != null) {
                    executionException.addSuppressed(runtimeException);
                }
                throw executionException;
            }
            throw (RuntimeException)Exceptions.chain((Throwable)new CancellationException(), (Throwable)runtimeException);
        }
    }

    public void waitTermination(long timeout, TimeUnit unit) {
        throw new UnsupportedOperationException("Not supported for repeating tasks.");
    }

    public T get() {
        throw new UnsupportedOperationException("Not supported for repeating tasks.");
    }

    public void registerCancelListener(CancelListener listener) {
        this.cancelListeners.add(listener);
    }

    MonitoredJobInfo getMonitoringInfo() {
        if (JobMonitoringParams.NOT_MONITORED == this.jobMonitoringParams) {
            return null;
        }
        return new MonitoredJobInfo(this.jobId, this.group, Instant.ofEpochMilli(this.submittedMillis), this.jobMonitoringParams.getSubmitter(), this.jobMonitoringParams.getTargetDatabaseName(), this.jobMonitoringParams.getDescription(), Instant.ofEpochMilli(TimeUnit.NANOSECONDS.toMillis(this.nextDeadlineNanos)), this.reschedulingDelayNanos == 0L ? null : Duration.ofNanos(this.reschedulingDelayNanos), this.getStatus(), this.getJobType(), this.jobMonitoringParams.getCurrentStateDescription());
    }

    private MonitoredJobInfo.State getStatus() {
        int state = this.state.get();
        switch (state) {
            case 0: 
            case 1: {
                return MonitoredJobInfo.State.SCHEDULED;
            }
            case 2: 
            case 3: {
                return MonitoredJobInfo.State.EXECUTING;
            }
        }
        throw new IllegalStateException("Unexpected job state: " + state);
    }

    private void recordFailedRun(Instant executionStart, Instant failureTime, Throwable t) {
        if (this.jobMonitoringParams == JobMonitoringParams.NOT_MONITORED) {
            return;
        }
        FailedJobRun failedJobRun = new FailedJobRun(this.jobId, this.group, this.jobMonitoringParams.getSubmitter(), this.jobMonitoringParams.getTargetDatabaseName(), this.jobMonitoringParams.getDescription(), this.getJobType(), Instant.ofEpochMilli(this.submittedMillis), executionStart, failureTime, t);
        this.failedJobRunsStore.add(failedJobRun);
    }

    private JobType getJobType() {
        return this.reschedulingDelayNanos > 0L ? JobType.PERIODIC : JobType.DELAYED;
    }
}

