/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery.facade;

import java.time.Instant;
import org.neo4j.kernel.recovery.RecoveryPredicate;

public interface RecoveryCriteria {
    public static final RecoveryCriteria ALL = () -> RecoveryPredicate.ALL;

    public static RecoveryCriteria until(long txId) {
        return new TransactionIdCriteria(txId);
    }

    public static RecoveryCriteria until(Instant date) {
        return new TransactionDateCriteria(date);
    }

    public RecoveryPredicate toPredicate();

    public static class TransactionIdCriteria
    implements RecoveryCriteria {
        private final long txId;

        TransactionIdCriteria(long txId) {
            this.txId = txId;
        }

        public long getTxId() {
            return this.txId;
        }

        @Override
        public RecoveryPredicate toPredicate() {
            return RecoveryPredicate.untilTransactionId(this.txId);
        }
    }

    public static class TransactionDateCriteria
    implements RecoveryCriteria {
        private final Instant instant;

        TransactionDateCriteria(Instant instant) {
            this.instant = instant;
        }

        public long getEpochMillis() {
            return this.instant.toEpochMilli();
        }

        @Override
        public RecoveryPredicate toPredicate() {
            return RecoveryPredicate.untilInstant(this.instant);
        }
    }
}

