/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.configuration.Config;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.LoggingMonitor;
import org.neo4j.kernel.impl.factory.DbmsInfo;
import org.neo4j.kernel.impl.factory.OperationalMode;
import org.neo4j.logging.Log;
import org.neo4j.logging.internal.LogService;
import org.neo4j.monitoring.Monitors;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.token.TokenHolders;

public abstract class AbstractIndexProviderFactory<T extends IndexProvider> {
    public T create(PageCache pageCache, FileSystemAbstraction fs, LogService logService, Monitors monitors, Config config, DatabaseReadOnlyChecker readOnlyChecker, DbmsInfo dbmsInfo, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, PageCacheTracer pageCacheTracer, DatabaseLayout databaseLayout, TokenHolders tokenHolders, JobScheduler scheduler) {
        if (OperationalMode.SINGLE != dbmsInfo.operationalMode) {
            readOnlyChecker = DatabaseReadOnlyChecker.writable();
        }
        Log log = logService.getInternalLogProvider().getLog(this.loggingClass());
        String monitorTag = this.descriptor().toString();
        monitors.addMonitorListener((Object)new LoggingMonitor(log), new String[]{monitorTag});
        return this.internalCreate(pageCache, fs, monitors, monitorTag, config, readOnlyChecker, recoveryCleanupWorkCollector, databaseLayout, pageCacheTracer, log, tokenHolders, scheduler);
    }

    protected abstract Class<?> loggingClass();

    public abstract IndexProviderDescriptor descriptor();

    protected abstract T internalCreate(PageCache var1, FileSystemAbstraction var2, Monitors var3, String var4, Config var5, DatabaseReadOnlyChecker var6, RecoveryCleanupWorkCollector var7, DatabaseLayout var8, PageCacheTracer var9, Log var10, TokenHolders var11, JobScheduler var12);
}

