/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.function.IntFunction;
import org.neo4j.common.EntityType;
import org.neo4j.configuration.Config;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.internal.helpers.collection.BoundedIterable;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.TokenIndexReader;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.index.schema.DatabaseIndexContext;
import org.neo4j.kernel.impl.index.schema.DefaultTokenIndexReader;
import org.neo4j.kernel.impl.index.schema.EntityTokenRange;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.index.schema.NativeAllEntriesTokenScanReader;
import org.neo4j.kernel.impl.index.schema.NativeIndexHeaderWriter;
import org.neo4j.kernel.impl.index.schema.TokenIndex;
import org.neo4j.kernel.impl.index.schema.TokenScanKey;
import org.neo4j.kernel.impl.index.schema.TokenScanValue;
import org.neo4j.storageengine.api.NodePropertyAccessor;

public class TokenIndexAccessor
extends TokenIndex
implements IndexAccessor {
    private final EntityType entityType;

    public TokenIndexAccessor(DatabaseIndexContext databaseIndexContext, DatabaseLayout directoryStructure, IndexFiles indexFiles, Config config, IndexDescriptor descriptor, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector) {
        super(databaseIndexContext, indexFiles, descriptor);
        this.entityType = descriptor.schema().entityType();
        this.instantiateTree(recoveryCleanupWorkCollector, new NativeIndexHeaderWriter(0));
        this.instantiateUpdater(config, directoryStructure, this.entityType);
    }

    public IndexUpdater newUpdater(IndexUpdateMode mode, CursorContext cursorContext) {
        this.assertTreeOpen();
        try {
            return this.singleUpdater.initialize((Writer<TokenScanKey, TokenScanValue>)this.index.writer(cursorContext));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void force(CursorContext cursorContext) {
        this.index.checkpoint(cursorContext);
        this.writeMonitor.force();
    }

    public void refresh() {
    }

    public void close() {
        this.closeResources();
    }

    public ValueIndexReader newValueReader() {
        throw new UnsupportedOperationException("Not applicable for token indexes ");
    }

    public TokenIndexReader newTokenReader() {
        this.assertTreeOpen();
        return new DefaultTokenIndexReader((GBPTree<TokenScanKey, TokenScanValue>)this.index);
    }

    public BoundedIterable<EntityTokenRange> newAllEntriesTokenReader(long fromEntityId, long toEntityId, CursorContext cursorContext) {
        IntFunction<Seeker<TokenScanKey, TokenScanValue>> seekProvider = tokenId -> {
            try {
                return this.index.seek((Object)new TokenScanKey().set(tokenId, fromEntityId / 64L), (Object)new TokenScanKey().set(tokenId, (toEntityId - 1L) / 64L + 1L), cursorContext);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
        int highestTokenId = -1;
        try (Seeker cursor = this.index.seek((Object)new TokenScanKey().set(Integer.MAX_VALUE, Long.MAX_VALUE), (Object)new TokenScanKey().set(0, -1L), cursorContext);){
            if (cursor.next()) {
                highestTokenId = ((TokenScanKey)cursor.key()).tokenId;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new NativeAllEntriesTokenScanReader(seekProvider, highestTokenId, this.entityType);
    }

    public BoundedIterable<Long> newAllEntriesValueReader(long fromIdInclusive, long toIdExclusive, CursorContext cursorContext) {
        throw new UnsupportedOperationException("Not applicable for token indexes");
    }

    public ResourceIterator<Path> snapshotFiles() {
        return Iterators.asResourceIterator((Iterator)Iterators.iterator((Object)this.indexFiles.getStoreFile()));
    }

    public void verifyDeferredConstraints(NodePropertyAccessor nodePropertyAccessor) {
    }

    public long estimateNumberOfEntries(CursorContext cursorContext) {
        throw new UnsupportedOperationException("Not applicable for token indexes");
    }

    public void drop() {
        this.index.setDeleteOnClose(true);
        this.closeResources();
        this.indexFiles.clear();
    }
}

