/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.internal.helpers.collection.BoundedIterable;
import org.neo4j.internal.helpers.collection.PrefetchingIterator;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NullValue;

public class NativeAllEntriesReader<KEY extends NativeIndexKey<KEY>>
implements BoundedIterable<Long> {
    private final GBPTree<KEY, NullValue> tree;
    private final Layout<KEY, NullValue> layout;
    private final long fromIdInclusive;
    private final long toIdExclusive;
    private final CursorContext cursorContext;
    private Seeker<KEY, NullValue> seeker;

    NativeAllEntriesReader(GBPTree<KEY, NullValue> tree, Layout<KEY, NullValue> layout, long fromIdInclusive, long toIdExclusive, CursorContext cursorContext) {
        this.tree = tree;
        this.layout = layout;
        this.fromIdInclusive = fromIdInclusive;
        this.toIdExclusive = toIdExclusive;
        this.cursorContext = cursorContext;
    }

    public Iterator<Long> iterator() {
        NativeIndexKey from = (NativeIndexKey)((Object)this.layout.newKey());
        from.initialize(Long.MIN_VALUE);
        from.initValuesAsLowest();
        NativeIndexKey to = (NativeIndexKey)((Object)this.layout.newKey());
        to.initialize(Long.MAX_VALUE);
        to.initValuesAsHighest();
        try {
            this.closeSeeker();
            this.seeker = this.tree.seek((Object)from, (Object)to, this.cursorContext);
            return new PrefetchingIterator<Long>(){

                protected Long fetchNextOrNull() {
                    try {
                        long id;
                        do {
                            if (NativeAllEntriesReader.this.seeker.next()) continue;
                            return null;
                        } while ((id = ((NativeIndexKey)((Object)NativeAllEntriesReader.this.seeker.key())).getEntityId()) < NativeAllEntriesReader.this.fromIdInclusive || id >= NativeAllEntriesReader.this.toIdExclusive);
                        return id;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            };
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void closeSeeker() throws IOException {
        if (this.seeker != null) {
            this.seeker.close();
            this.seeker = null;
        }
    }

    public void close() throws Exception {
        this.closeSeeker();
    }

    public long maxCount() {
        return -1L;
    }
}

