/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.IntSets;
import org.eclipse.collections.impl.iterator.ImmutableEmptyLongIterator;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.TokenSet;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.newapi.CursorPool;
import org.neo4j.kernel.impl.newapi.DefaultPropertyCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipTraversalCursor;
import org.neo4j.kernel.impl.newapi.Labels;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.kernel.impl.newapi.TraceableCursor;
import org.neo4j.storageengine.api.AllNodeScan;
import org.neo4j.storageengine.api.Degrees;
import org.neo4j.storageengine.api.LongReference;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.storageengine.api.Reference;
import org.neo4j.storageengine.api.RelationshipDirection;
import org.neo4j.storageengine.api.RelationshipSelection;
import org.neo4j.storageengine.api.Scan;
import org.neo4j.storageengine.api.StorageEntityCursor;
import org.neo4j.storageengine.api.StorageNodeCursor;
import org.neo4j.storageengine.api.StorageRelationshipTraversalCursor;
import org.neo4j.storageengine.api.txstate.LongDiffSets;
import org.neo4j.storageengine.api.txstate.NodeState;
import org.neo4j.storageengine.util.EagerDegrees;
import org.neo4j.storageengine.util.SingleDegree;

class DefaultNodeCursor
extends TraceableCursor<DefaultNodeCursor>
implements NodeCursor {
    Read read;
    boolean checkHasChanges;
    boolean hasChanges;
    private LongIterator addedNodes;
    StorageNodeCursor storeCursor;
    private final StorageNodeCursor securityStoreNodeCursor;
    private final StorageRelationshipTraversalCursor securityStoreRelationshipCursor;
    private long currentAddedInTx;
    private long single;
    private boolean isSingle;
    private AccessMode accessMode;

    DefaultNodeCursor(CursorPool<DefaultNodeCursor> pool, StorageNodeCursor storeCursor, StorageNodeCursor securityStoreNodeCursor, StorageRelationshipTraversalCursor securityStoreRelationshipCursor) {
        super(pool);
        this.storeCursor = storeCursor;
        this.securityStoreNodeCursor = securityStoreNodeCursor;
        this.securityStoreRelationshipCursor = securityStoreRelationshipCursor;
    }

    void scan(Read read) {
        this.storeCursor.scan();
        this.read = read;
        this.isSingle = false;
        this.currentAddedInTx = -1L;
        this.checkHasChanges = true;
        this.addedNodes = ImmutableEmptyLongIterator.INSTANCE;
        this.accessMode = read.ktx.securityContext().mode();
        if (this.tracer != null) {
            this.tracer.onAllNodesScan();
        }
    }

    boolean scanBatch(Read read, AllNodeScan scan, int sizeHint, LongIterator addedNodes, boolean hasChanges, AccessMode accessMode) {
        this.read = read;
        this.isSingle = false;
        this.currentAddedInTx = -1L;
        this.checkHasChanges = false;
        this.hasChanges = hasChanges;
        this.addedNodes = addedNodes;
        this.accessMode = accessMode;
        boolean scanBatch = this.storeCursor.scanBatch((Scan)scan, sizeHint);
        return addedNodes.hasNext() || scanBatch;
    }

    void single(long reference, Read read) {
        this.storeCursor.single(reference);
        this.read = read;
        this.single = reference;
        this.isSingle = true;
        this.currentAddedInTx = -1L;
        this.checkHasChanges = true;
        this.accessMode = read.ktx.securityContext().mode();
        this.addedNodes = ImmutableEmptyLongIterator.INSTANCE;
    }

    protected boolean currentNodeIsAddedInTx() {
        return this.currentAddedInTx != -1L;
    }

    public long nodeReference() {
        if (this.currentAddedInTx != -1L) {
            return this.currentAddedInTx;
        }
        return this.storeCursor.entityReference();
    }

    public TokenSet labels() {
        if (this.currentAddedInTx != -1L) {
            TransactionState txState = this.read.txState();
            return Labels.from(txState.nodeStateLabelDiffSets(this.currentAddedInTx).getAdded());
        }
        if (this.hasChanges()) {
            TransactionState txState = this.read.txState();
            long[] longs = this.storeCursor.labels();
            LongHashSet labels = new LongHashSet();
            for (long labelToken : longs) {
                labels.add(labelToken);
            }
            return Labels.from((LongSet)txState.augmentLabels((MutableLongSet)labels, txState.getNodeState(this.storeCursor.entityReference())));
        }
        return Labels.from(this.storeCursor.labels());
    }

    public TokenSet labelsIgnoringTxStateSetRemove() {
        if (this.currentAddedInTx != -1L) {
            TransactionState txState = this.read.txState();
            return Labels.from(txState.nodeStateLabelDiffSets(this.currentAddedInTx).getAdded());
        }
        return Labels.from(this.storeCursor.labels());
    }

    public boolean hasLabel(int label) {
        if (this.hasChanges()) {
            TransactionState txState = this.read.txState();
            LongDiffSets diffSets = txState.nodeStateLabelDiffSets(this.nodeReference());
            if (diffSets.getAdded().contains((long)label)) {
                return true;
            }
            if (diffSets.getRemoved().contains((long)label) || this.currentAddedInTx != -1L) {
                return false;
            }
        }
        return this.storeCursor.hasLabel(label);
    }

    public void relationships(RelationshipTraversalCursor cursor, RelationshipSelection selection) {
        ((DefaultRelationshipTraversalCursor)cursor).init(this, selection, this.read);
    }

    public boolean supportsFastRelationshipsTo() {
        return this.currentAddedInTx == -1L && this.storeCursor.supportsFastRelationshipsTo();
    }

    public void relationshipsTo(RelationshipTraversalCursor relationships, RelationshipSelection selection, long neighbourNodeReference) {
        ((DefaultRelationshipTraversalCursor)relationships).init(this, selection, neighbourNodeReference, this.read);
    }

    public void properties(PropertyCursor cursor, PropertySelection selection) {
        ((DefaultPropertyCursor)cursor).initNode(this, selection, this.read, this.read);
    }

    public long relationshipsReference() {
        return this.currentAddedInTx != -1L ? -1L : this.storeCursor.relationshipsReference();
    }

    public Reference propertiesReference() {
        return this.currentAddedInTx != -1L ? LongReference.NULL_REFERENCE : this.storeCursor.propertiesReference();
    }

    public boolean supportsFastDegreeLookup() {
        return this.currentAddedInTx == -1L && this.storeCursor.supportsFastDegreeLookup() && this.allowsTraverseAll();
    }

    public int[] relationshipTypes() {
        MutableIntSet types;
        boolean hasChanges = this.hasChanges();
        NodeState nodeTxState = hasChanges ? this.read.txState().getNodeState(this.nodeReference()) : null;
        int[] storedTypes = this.currentAddedInTx == -1L ? this.storeCursor.relationshipTypes() : null;
        MutableIntSet mutableIntSet = types = storedTypes != null ? IntSets.mutable.of(storedTypes) : IntSets.mutable.empty();
        if (nodeTxState != null) {
            types.addAll(nodeTxState.getAddedRelationshipTypes());
        }
        return types.toArray();
    }

    public Degrees degrees(RelationshipSelection selection) {
        EagerDegrees degrees = new EagerDegrees();
        this.fillDegrees(selection, (Degrees.Mutator)degrees);
        return degrees;
    }

    public int degree(RelationshipSelection selection) {
        SingleDegree degrees = new SingleDegree();
        this.fillDegrees(selection, (Degrees.Mutator)degrees);
        return degrees.getTotal();
    }

    public int degreeWithMax(int maxDegree, RelationshipSelection selection) {
        SingleDegree degrees = new SingleDegree(maxDegree);
        this.fillDegrees(selection, (Degrees.Mutator)degrees);
        return Math.min(degrees.getTotal(), maxDegree);
    }

    private void fillDegrees(RelationshipSelection selection, Degrees.Mutator degrees) {
        NodeState nodeTxState;
        boolean hasChanges = this.hasChanges();
        NodeState nodeState = nodeTxState = hasChanges ? this.read.txState().getNodeState(this.nodeReference()) : null;
        if (this.currentAddedInTx == -1L) {
            if (this.allowsTraverseAll()) {
                this.storeCursor.degrees(selection, degrees);
            } else {
                this.readRestrictedDegrees(selection, degrees);
            }
        }
        if (nodeTxState != null) {
            IntIterator txTypes = nodeTxState.getAddedAndRemovedRelationshipTypes().intIterator();
            while (txTypes.hasNext()) {
                int loop;
                int incoming;
                int outgoing;
                int type = txTypes.next();
                if (!selection.test(type) || degrees.add(type, outgoing = selection.test(RelationshipDirection.OUTGOING) ? nodeTxState.augmentDegree(RelationshipDirection.OUTGOING, 0, type) : 0, incoming = selection.test(RelationshipDirection.INCOMING) ? nodeTxState.augmentDegree(RelationshipDirection.INCOMING, 0, type) : 0, loop = selection.test(RelationshipDirection.LOOP) ? nodeTxState.augmentDegree(RelationshipDirection.LOOP, 0, type) : 0)) continue;
                return;
            }
        }
    }

    private void readRestrictedDegrees(RelationshipSelection selection, Degrees.Mutator degrees) {
        this.storeCursor.relationships(this.securityStoreRelationshipCursor, selection);
        while (this.securityStoreRelationshipCursor.next()) {
            boolean incoming;
            long target;
            int type = this.securityStoreRelationshipCursor.type();
            if (!this.accessMode.allowsTraverseRelType(type)) continue;
            long source = this.securityStoreRelationshipCursor.sourceNodeReference();
            boolean loop = source == (target = this.securityStoreRelationshipCursor.targetNodeReference());
            boolean outgoing = !loop && source == this.nodeReference();
            boolean bl = incoming = !loop && !outgoing;
            if (!loop) {
                this.securityStoreNodeCursor.single(outgoing ? target : source);
                if (!this.securityStoreNodeCursor.next() || !this.accessMode.allowsTraverseNode(this.securityStoreNodeCursor.labels())) continue;
            }
            degrees.add(type, outgoing ? 1 : 0, incoming ? 1 : 0, loop ? 1 : 0);
        }
    }

    public boolean next() {
        boolean hasChanges = this.hasChanges();
        if (hasChanges) {
            if (this.addedNodes.hasNext()) {
                this.currentAddedInTx = this.addedNodes.next();
                if (this.tracer != null) {
                    this.tracer.onNode(this.nodeReference());
                }
                return true;
            }
            this.currentAddedInTx = -1L;
        }
        while (this.storeCursor.next()) {
            boolean skip = hasChanges && this.read.txState().nodeIsDeletedInThisTx(this.storeCursor.entityReference());
            if (skip || !this.allowsTraverse()) continue;
            if (this.tracer != null) {
                this.tracer.onNode(this.nodeReference());
            }
            return true;
        }
        return false;
    }

    boolean allowsTraverse() {
        return this.accessMode.allowsTraverseAllLabels() || this.accessMode.allowsTraverseNode(this.storeCursor.labels());
    }

    boolean allowsTraverseAll() {
        return this.accessMode.allowsTraverseAllRelTypes() && this.accessMode.allowsTraverseAllLabels();
    }

    @Override
    public void closeInternal() {
        if (!this.isClosed()) {
            this.read = null;
            this.checkHasChanges = true;
            this.addedNodes = ImmutableEmptyLongIterator.INSTANCE;
            this.storeCursor.close();
            this.storeCursor.reset();
            if (this.securityStoreNodeCursor != null) {
                this.securityStoreNodeCursor.reset();
            }
            if (this.securityStoreRelationshipCursor != null) {
                this.securityStoreRelationshipCursor.reset();
            }
            this.accessMode = null;
        }
        super.closeInternal();
    }

    public boolean isClosed() {
        return this.read == null;
    }

    boolean hasChanges() {
        if (this.checkHasChanges) {
            this.computeHasChanges();
        }
        return this.hasChanges;
    }

    private void computeHasChanges() {
        this.checkHasChanges = false;
        this.hasChanges = this.read.hasTxStateWithChanges();
        if (this.hasChanges) {
            this.addedNodes = this.isSingle ? (this.read.txState().nodeIsAddedInThisTx(this.single) ? PrimitiveLongCollections.single((long)this.single) : ImmutableEmptyLongIterator.INSTANCE) : this.read.txState().addedAndRemovedNodes().getAdded().freeze().longIterator();
        }
    }

    public String toString() {
        if (this.isClosed()) {
            return "NodeCursor[closed state]";
        }
        return "NodeCursor[id=" + this.nodeReference() + ", " + this.storeCursor + "]";
    }

    void release() {
        IOUtils.closeAllUnchecked((AutoCloseable[])new StorageEntityCursor[]{this.storeCursor, this.securityStoreNodeCursor, this.securityStoreRelationshipCursor});
    }
}

