/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.internal.event;

import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.event.PropertyEntry;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class RelationshipPropertyEntryView
implements PropertyEntry<Relationship> {
    static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(RelationshipPropertyEntryView.class);
    private final Relationship relationship;
    private final String key;
    private final Value newValue;
    private final Value oldValue;

    RelationshipPropertyEntryView(Relationship relationship, String key, Value newValue, Value oldValue) {
        this.relationship = relationship;
        this.key = key;
        this.newValue = newValue;
        this.oldValue = oldValue;
    }

    public Relationship entity() {
        return this.relationship;
    }

    public String key() {
        return this.key;
    }

    public Object previouslyCommittedValue() {
        return this.oldValue.asObjectCopy();
    }

    public Object value() {
        if (this.newValue == null || this.newValue == Values.NO_VALUE) {
            throw new IllegalStateException("This property has been removed, it has no value anymore: " + this);
        }
        return this.newValue.asObjectCopy();
    }

    public String toString() {
        return "RelationshipPropertyEntryView{relId=" + this.relationship.getId() + ", key='" + this.key + "', newValue=" + this.newValue + ", oldValue=" + this.oldValue + "}";
    }
}

