/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.List;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurve;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurveConfiguration;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.index.BridgingIndexProgressor;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexProvider;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexReader;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.QueryValidator;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettings;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.Values;

class GenericNativeIndexReader
extends NativeIndexReader<GenericKey, NativeIndexValue> {
    private final IndexSpecificSpaceFillingCurveSettings spaceFillingCurveSettings;
    private final SpaceFillingCurveConfiguration configuration;

    GenericNativeIndexReader(GBPTree<GenericKey, NativeIndexValue> tree, IndexLayout<GenericKey, NativeIndexValue> layout, IndexDescriptor descriptor, IndexSpecificSpaceFillingCurveSettings spaceFillingCurveSettings, SpaceFillingCurveConfiguration configuration) {
        super(tree, layout, descriptor);
        this.spaceFillingCurveSettings = spaceFillingCurveSettings;
        this.configuration = configuration;
    }

    @Override
    void validateQuery(IndexQueryConstraints constraints, PropertyIndexQuery[] predicates) {
        QueryValidator.validateOrder(GenericNativeIndexProvider.CAPABILITY, constraints.order(), predicates);
        QueryValidator.validateCompositeQuery(predicates);
    }

    @Override
    public void query(QueryContext context, IndexProgressor.EntityValueClient client, IndexQueryConstraints constraints, PropertyIndexQuery ... query) {
        PropertyIndexQuery.GeometryRangePredicate geometryRangePredicate = GenericNativeIndexReader.getGeometryRangePredicateIfAny(query);
        if (geometryRangePredicate != null) {
            this.validateQuery(constraints, query);
            try {
                BridgingIndexProgressor multiProgressor = new BridgingIndexProgressor(client, this.descriptor.schema().getPropertyIds());
                client.initialize(this.descriptor, (IndexProgressor)multiProgressor, query, constraints, false);
                double[] from = geometryRangePredicate.from() == null ? null : geometryRangePredicate.from().coordinate();
                double[] to = geometryRangePredicate.to() == null ? null : geometryRangePredicate.to().coordinate();
                CoordinateReferenceSystem crs = geometryRangePredicate.crs();
                SpaceFillingCurve curve = this.spaceFillingCurveSettings.forCrs(crs);
                List ranges = curve.getTilesIntersectingEnvelope(from, to, this.configuration);
                for (SpaceFillingCurve.LongRange range : ranges) {
                    GenericKey treeKeyFrom = (GenericKey)((Object)this.layout.newKey());
                    GenericKey treeKeyTo = (GenericKey)((Object)this.layout.newKey());
                    this.initializeFromToKeys(treeKeyFrom, treeKeyTo);
                    boolean needFiltering = GenericNativeIndexReader.initializeRangeForGeometrySubQuery(treeKeyFrom, treeKeyTo, query, crs, range);
                    this.startSeekForInitializedRange((IndexProgressor.EntityValueClient)multiProgressor, treeKeyFrom, treeKeyTo, query, constraints, needFiltering, context.cursorContext());
                }
            }
            catch (IllegalArgumentException e) {
                client.initialize(this.descriptor, IndexProgressor.EMPTY, query, constraints, false);
            }
        } else {
            super.query(context, client, constraints, query);
        }
    }

    private static boolean initializeRangeForGeometrySubQuery(GenericKey treeKeyFrom, GenericKey treeKeyTo, PropertyIndexQuery[] query, CoordinateReferenceSystem crs, SpaceFillingCurve.LongRange range) {
        boolean needsFiltering = false;
        block7: for (int i = 0; i < query.length; ++i) {
            PropertyIndexQuery predicate = query[i];
            switch (predicate.type()) {
                case exists: {
                    treeKeyFrom.initValueAsLowest(i, ValueGroup.UNKNOWN);
                    treeKeyTo.initValueAsHighest(i, ValueGroup.UNKNOWN);
                    continue block7;
                }
                case exact: {
                    PropertyIndexQuery.ExactPredicate exactPredicate = (PropertyIndexQuery.ExactPredicate)predicate;
                    treeKeyFrom.initFromValue(i, exactPredicate.value(), NativeIndexKey.Inclusion.NEUTRAL);
                    treeKeyTo.initFromValue(i, exactPredicate.value(), NativeIndexKey.Inclusion.NEUTRAL);
                    continue block7;
                }
                case range: {
                    if (GenericNativeIndexReader.isGeometryRangeQuery(predicate)) {
                        treeKeyFrom.stateSlot(i).writePointDerived(crs, range.min, NativeIndexKey.Inclusion.LOW);
                        treeKeyTo.stateSlot(i).writePointDerived(crs, range.max + 1L, NativeIndexKey.Inclusion.HIGH);
                        needsFiltering = true;
                        continue block7;
                    }
                    PropertyIndexQuery.RangePredicate rangePredicate = (PropertyIndexQuery.RangePredicate)predicate;
                    GenericNativeIndexReader.initFromForRange(i, rangePredicate, treeKeyFrom);
                    GenericNativeIndexReader.initToForRange(i, rangePredicate, treeKeyTo);
                    continue block7;
                }
                case stringPrefix: {
                    PropertyIndexQuery.StringPrefixPredicate prefixPredicate = (PropertyIndexQuery.StringPrefixPredicate)predicate;
                    treeKeyFrom.stateSlot(i).initAsPrefixLow(prefixPredicate.prefix());
                    treeKeyTo.stateSlot(i).initAsPrefixHigh(prefixPredicate.prefix());
                    continue block7;
                }
                case stringSuffix: 
                case stringContains: {
                    treeKeyFrom.initValueAsLowest(i, ValueGroup.TEXT);
                    treeKeyTo.initValueAsHighest(i, ValueGroup.TEXT);
                    needsFiltering = true;
                    continue block7;
                }
                default: {
                    throw new IllegalArgumentException("IndexQuery of type " + predicate.type() + " is not supported.");
                }
            }
        }
        return needsFiltering;
    }

    @Override
    boolean initializeRangeForQuery(GenericKey treeKeyFrom, GenericKey treeKeyTo, PropertyIndexQuery[] query) {
        return GenericNativeIndexReader.initializeRangeForGeometrySubQuery(treeKeyFrom, treeKeyTo, query, null, null);
    }

    private static void initFromForRange(int stateSlot, PropertyIndexQuery.RangePredicate<?> rangePredicate, GenericKey treeKeyFrom) {
        Value fromValue = rangePredicate.fromValue();
        if (fromValue == Values.NO_VALUE) {
            treeKeyFrom.initValueAsLowest(stateSlot, rangePredicate.valueGroup());
        } else {
            treeKeyFrom.initFromValue(stateSlot, fromValue, GenericNativeIndexReader.fromInclusion(rangePredicate));
            treeKeyFrom.setCompareId(true);
        }
    }

    private static void initToForRange(int stateSlot, PropertyIndexQuery.RangePredicate<?> rangePredicate, GenericKey treeKeyTo) {
        Value toValue = rangePredicate.toValue();
        if (toValue == Values.NO_VALUE) {
            treeKeyTo.initValueAsHighest(stateSlot, rangePredicate.valueGroup());
        } else {
            treeKeyTo.initFromValue(stateSlot, toValue, GenericNativeIndexReader.toInclusion(rangePredicate));
            treeKeyTo.setCompareId(true);
        }
    }

    private static NativeIndexKey.Inclusion fromInclusion(PropertyIndexQuery.RangePredicate<?> rangePredicate) {
        return rangePredicate.fromInclusive() ? NativeIndexKey.Inclusion.LOW : NativeIndexKey.Inclusion.HIGH;
    }

    private static NativeIndexKey.Inclusion toInclusion(PropertyIndexQuery.RangePredicate<?> rangePredicate) {
        return rangePredicate.toInclusive() ? NativeIndexKey.Inclusion.HIGH : NativeIndexKey.Inclusion.LOW;
    }

    private static PropertyIndexQuery.GeometryRangePredicate getGeometryRangePredicateIfAny(PropertyIndexQuery[] predicates) {
        for (PropertyIndexQuery predicate : predicates) {
            if (!GenericNativeIndexReader.isGeometryRangeQuery(predicate)) continue;
            return (PropertyIndexQuery.GeometryRangePredicate)predicate;
        }
        return null;
    }

    private static boolean isGeometryRangeQuery(PropertyIndexQuery predicate) {
        return predicate instanceof PropertyIndexQuery.GeometryRangePredicate;
    }
}

