/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.nio.file.Path;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.helpers.DatabaseReadOnlyChecker;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.LoggingMonitor;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.extension.ExtensionType;
import org.neo4j.kernel.extension.context.ExtensionContext;
import org.neo4j.kernel.impl.factory.OperationalMode;
import org.neo4j.kernel.recovery.RecoveryExtension;
import org.neo4j.logging.Log;
import org.neo4j.logging.internal.LogService;
import org.neo4j.monitoring.Monitors;

@RecoveryExtension
public abstract class AbstractIndexProviderFactory
extends ExtensionFactory<Dependencies> {
    protected AbstractIndexProviderFactory(String key) {
        super(ExtensionType.DATABASE, key);
    }

    public IndexProvider newInstance(ExtensionContext context, Dependencies dependencies) {
        PageCache pageCache = dependencies.pageCache();
        Path databaseDir = context.directory();
        FileSystemAbstraction fs = dependencies.fileSystem();
        Log log = dependencies.getLogService().getInternalLogProvider().getLog(this.loggingClass());
        Monitors monitors = dependencies.monitors();
        String monitorTag = this.descriptor().toString();
        monitors.addMonitorListener((Object)new LoggingMonitor(log), new String[]{monitorTag});
        Config config = dependencies.getConfig();
        DatabaseReadOnlyChecker readOnlyChecker = dependencies.readOnlyChecker();
        if (OperationalMode.SINGLE != context.dbmsInfo().operationalMode) {
            readOnlyChecker = DatabaseReadOnlyChecker.writable();
        }
        RecoveryCleanupWorkCollector recoveryCleanupWorkCollector = dependencies.recoveryCleanupWorkCollector();
        PageCacheTracer pageCacheTracer = dependencies.pageCacheTracer();
        DatabaseLayout databaseLayout = dependencies.databaseLayout();
        return this.internalCreate(pageCache, databaseDir, fs, monitors, monitorTag, config, readOnlyChecker, recoveryCleanupWorkCollector, databaseLayout, pageCacheTracer);
    }

    protected abstract Class<?> loggingClass();

    public abstract IndexProviderDescriptor descriptor();

    protected abstract IndexProvider internalCreate(PageCache var1, Path var2, FileSystemAbstraction var3, Monitors var4, String var5, Config var6, DatabaseReadOnlyChecker var7, RecoveryCleanupWorkCollector var8, DatabaseLayout var9, PageCacheTracer var10);

    public static interface Dependencies {
        public PageCache pageCache();

        public FileSystemAbstraction fileSystem();

        public LogService getLogService();

        public Monitors monitors();

        public Config getConfig();

        public RecoveryCleanupWorkCollector recoveryCleanupWorkCollector();

        public DatabaseLayout databaseLayout();

        public PageCacheTracer pageCacheTracer();

        public DatabaseReadOnlyChecker readOnlyChecker();
    }
}

