/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.diagnostics.providers;

import java.io.IOException;
import java.nio.file.Path;
import org.neo4j.internal.diagnostics.DiagnosticsLogger;
import org.neo4j.internal.diagnostics.NamedDiagnosticsProvider;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.database.Database;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointFile;

public class TransactionRangeDiagnostics
extends NamedDiagnosticsProvider {
    private final Database database;

    TransactionRangeDiagnostics(Database database) {
        super("Transaction log");
        this.database = database;
    }

    public void dump(DiagnosticsLogger logger) {
        LogFiles logFiles = (LogFiles)this.database.getDependencyResolver().resolveDependency(LogFiles.class);
        try {
            logger.log("Transaction log files stored on file store: " + FileUtils.getFileStoreType((Path)logFiles.logFilesDirectory()));
            this.dumpTransactionLogInformation(logger, logFiles.getLogFile());
            this.dumpCheckpointLogInformation(logger, logFiles.getCheckpointFile());
        }
        catch (Exception e) {
            logger.log("Error trying to dump transaction log files info.");
            logger.log(Exceptions.stringify((Throwable)e));
        }
    }

    private void dumpTransactionLogInformation(DiagnosticsLogger logger, LogFile logFile) throws IOException {
        logger.log("Transaction log files:");
        logger.log(" - existing transaction log versions " + logFile.getLowestLogVersion() + "-" + logFile.getHighestLogVersion());
        long logVersion = logFile.getLowestLogVersion();
        while (logFile.versionExists(logVersion)) {
            if (logFile.hasAnyEntries(logVersion)) {
                LogHeader header = logFile.extractHeader(logVersion);
                long firstTransactionIdInThisLog = header.getLastCommittedTxId() + 1L;
                logger.log(" - oldest transaction " + firstTransactionIdInThisLog + " found in log with version " + logVersion);
                return;
            }
            ++logVersion;
        }
        logger.log(" - no transactions found");
    }

    private void dumpCheckpointLogInformation(DiagnosticsLogger logger, CheckpointFile checkpointFile) throws IOException {
        logger.log("Checkpoint log files:");
        logger.log(" - existing checkpoint log versions " + checkpointFile.getLowestLogVersion() + "-" + checkpointFile.getHighestLogVersion());
        checkpointFile.findLatestCheckpoint().ifPresentOrElse(checkpoint -> logger.log(" - last checkpoint: " + checkpoint), () -> logger.log(" - no checkpoints found"));
    }
}

