/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.dbstructure;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.neo4j.common.EntityType;
import org.neo4j.internal.helpers.Strings;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.FulltextSchemaDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.constraints.ConstraintDescriptorFactory;
import org.neo4j.internal.schema.constraints.NodeExistenceConstraintDescriptor;
import org.neo4j.internal.schema.constraints.NodeKeyConstraintDescriptor;
import org.neo4j.internal.schema.constraints.RelExistenceConstraintDescriptor;
import org.neo4j.internal.schema.constraints.UniquenessConstraintDescriptor;
import org.neo4j.kernel.impl.util.dbstructure.ArgumentFormatter;

public enum DbStructureArgumentFormatter implements ArgumentFormatter
{
    INSTANCE;

    private static final List<String> IMPORTS;

    @Override
    public Collection<String> imports() {
        return IMPORTS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void formatArgument(Appendable builder, Object arg) throws IOException {
        if (arg == null) {
            builder.append("null");
            return;
        } else if (arg instanceof String) {
            builder.append('\"');
            Strings.escape((Appendable)builder, (String)arg.toString());
            builder.append('\"');
            return;
        } else if (arg instanceof Long) {
            builder.append(arg.toString());
            builder.append('L');
            return;
        } else if (arg instanceof Integer) {
            builder.append(arg.toString());
            return;
        } else if (arg instanceof Double) {
            double d = (Double)arg;
            if (Double.isNaN(d)) {
                builder.append("Double.NaN");
                return;
            } else if (Double.isInfinite(d)) {
                builder.append(d < 0.0 ? "Double.NEGATIVE_INFINITY" : "Double.POSITIVE_INFINITY");
                return;
            } else {
                builder.append(arg.toString());
                builder.append('d');
            }
            return;
        } else if (arg instanceof IndexDescriptor) {
            IndexDescriptor descriptor = (IndexDescriptor)arg;
            String className = IndexPrototype.class.getSimpleName();
            SchemaDescriptor schema = descriptor.schema();
            String methodName = !descriptor.isUnique() ? "forSchema" : "uniqueForSchema";
            builder.append(String.format("%s.%s( ", className, methodName));
            this.formatArgument(builder, schema);
            builder.append(" ).withName( \"").append(descriptor.getName()).append("\" )");
            builder.append(".materialise( ").append(String.valueOf(descriptor.getId())).append(" )");
            return;
        } else if (arg instanceof SchemaDescriptor) {
            SchemaDescriptor schema = (SchemaDescriptor)arg;
            if (schema.isLabelSchemaDescriptor()) {
                LabelSchemaDescriptor descriptor = schema.asLabelSchemaDescriptor();
                String className = SchemaDescriptor.class.getSimpleName();
                int labelId = descriptor.getLabelId();
                builder.append(String.format("%s.forLabel( %d, %s )", className, labelId, DbStructureArgumentFormatter.asString(descriptor.getPropertyIds())));
                return;
            } else if (schema.isRelationshipTypeSchemaDescriptor()) {
                RelationTypeSchemaDescriptor descriptor = schema.asRelationshipTypeSchemaDescriptor();
                String className = SchemaDescriptor.class.getSimpleName();
                int labelId = descriptor.getRelTypeId();
                builder.append(String.format("%s.forRelType( %d, %s )", className, labelId, DbStructureArgumentFormatter.asString(descriptor.getPropertyIds())));
                return;
            } else {
                if (!schema.isFulltextSchemaDescriptor()) throw new IllegalArgumentException(String.format("Can't handle argument of type: %s with value: %s", arg.getClass(), arg));
                FulltextSchemaDescriptor descriptor = schema.asFulltextSchemaDescriptor();
                String className = SchemaDescriptor.class.getSimpleName();
                int[] entityIds = descriptor.getEntityTokenIds();
                builder.append(String.format("%s.fulltext( EntityType.%s, IndexConfig.empty(), new int[] {%s}, new int[] {%s} )", className, descriptor.entityType().name(), DbStructureArgumentFormatter.asString(entityIds), DbStructureArgumentFormatter.asString(descriptor.getPropertyIds())));
            }
            return;
        } else {
            if (!(arg instanceof ConstraintDescriptor)) throw new IllegalArgumentException(String.format("Can't handle argument of type: %s with value: %s", arg.getClass(), arg));
            ConstraintDescriptor constraint = (ConstraintDescriptor)arg;
            EntityType entityType = constraint.schema().entityType();
            if (constraint.enforcesUniqueness() && !constraint.enforcesPropertyExistence() && entityType == EntityType.NODE) {
                String className = ConstraintDescriptorFactory.class.getSimpleName();
                int labelId = constraint.schema().getLabelId();
                builder.append(String.format("%s.uniqueForLabel( %d, %s )", className, labelId, DbStructureArgumentFormatter.asString(constraint.schema().getPropertyIds())));
                return;
            } else if (!constraint.enforcesUniqueness() && constraint.enforcesPropertyExistence() && entityType == EntityType.NODE) {
                String className = ConstraintDescriptorFactory.class.getSimpleName();
                int labelId = constraint.schema().getLabelId();
                builder.append(String.format("%s.existsForLabel( %d, %s )", className, labelId, DbStructureArgumentFormatter.asString(constraint.schema().getPropertyIds())));
                return;
            } else if (!constraint.enforcesUniqueness() && constraint.enforcesPropertyExistence() && entityType == EntityType.RELATIONSHIP) {
                SchemaDescriptor descriptor = constraint.schema();
                String className = ConstraintDescriptorFactory.class.getSimpleName();
                int relTypeId = descriptor.getRelTypeId();
                builder.append(String.format("%s.existsForReltype( %d, %s )", className, relTypeId, DbStructureArgumentFormatter.asString(descriptor.getPropertyIds())));
                return;
            } else {
                if (!constraint.enforcesUniqueness() || !constraint.enforcesPropertyExistence() || entityType != EntityType.NODE) throw new IllegalArgumentException(String.format("Can't handle argument of type: %s with value: %s", arg.getClass(), arg));
                String className = ConstraintDescriptorFactory.class.getSimpleName();
                int labelId = constraint.schema().getLabelId();
                builder.append(String.format("%s.nodeKeyForLabel( %d, %s )", className, labelId, DbStructureArgumentFormatter.asString(constraint.schema().getPropertyIds())));
            }
        }
    }

    private static String asString(int[] propertyIds) {
        List strings = Arrays.stream(propertyIds).mapToObj(i -> "" + i).collect(Collectors.toList());
        return String.join((CharSequence)", ", strings);
    }

    static {
        IMPORTS = Arrays.asList(ConstraintDescriptorFactory.class.getCanonicalName(), UniquenessConstraintDescriptor.class.getCanonicalName(), RelExistenceConstraintDescriptor.class.getCanonicalName(), NodeExistenceConstraintDescriptor.class.getCanonicalName(), NodeKeyConstraintDescriptor.class.getCanonicalName(), SchemaDescriptor.class.getCanonicalName(), IndexDescriptor.class.getCanonicalName(), IndexPrototype.class.getCanonicalName());
    }
}

