/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.impl.factory.primitive.IntLists;
import org.eclipse.collections.impl.factory.primitive.IntObjectMaps;
import org.neo4j.common.EntityType;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.kernel.impl.newapi.SchemaMatcher;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueTuple;
import org.neo4j.values.storable.Values;

public class IndexTxStateUpdater {
    private final StorageReader storageReader;
    private final Read read;
    private final IndexingService indexingService;

    public IndexTxStateUpdater(StorageReader storageReader, Read read, IndexingService indexingService) {
        this.storageReader = storageReader;
        this.read = read;
        this.indexingService = indexingService;
    }

    void onLabelChange(int labelId, int[] existingPropertyKeyIds, NodeCursor node, PropertyCursor propertyCursor, LabelChangeType changeType) {
        assert (this.noSchemaChangedInTx());
        Collection indexes = this.storageReader.valueIndexesGetRelated(new long[]{labelId}, existingPropertyKeyIds, EntityType.NODE);
        if (!indexes.isEmpty()) {
            MutableIntObjectMap materializedProperties = IntObjectMaps.mutable.empty();
            block4: for (IndexDescriptor index : indexes) {
                MemoryTracker memoryTracker = this.read.txState().memoryTracker();
                int[] indexPropertyIds = index.schema().getPropertyIds();
                Value[] values = IndexTxStateUpdater.getValueTuple(new NodeCursorWrapper(node), propertyCursor, -1, Values.NO_VALUE, indexPropertyIds, (MutableIntObjectMap<Value>)materializedProperties, memoryTracker);
                ValueTuple valueTuple = ValueTuple.of((Value[])values);
                memoryTracker.allocateHeap(valueTuple.getShallowSize());
                switch (changeType) {
                    case ADDED_LABEL: {
                        this.indexingService.validateBeforeCommit(index, values, node.nodeReference());
                        this.read.txState().indexDoUpdateEntry(index.schema(), node.nodeReference(), null, valueTuple);
                        continue block4;
                    }
                    case REMOVED_LABEL: {
                        this.read.txState().indexDoUpdateEntry(index.schema(), node.nodeReference(), valueTuple, null);
                        continue block4;
                    }
                }
                throw new IllegalStateException(changeType + " is not a supported event");
            }
        }
    }

    void onPropertyAdd(NodeCursor node, PropertyCursor propertyCursor, long[] labels, int propertyKeyId, int[] existingPropertyKeyIds, Value value) {
        this.onPropertyAdd(new NodeCursorWrapper(node), propertyCursor, labels, propertyKeyId, existingPropertyKeyIds, value);
    }

    void onPropertyRemove(NodeCursor node, PropertyCursor propertyCursor, long[] labels, int propertyKeyId, int[] existingPropertyKeyIds, Value value) {
        this.onPropertyRemove(new NodeCursorWrapper(node), propertyCursor, labels, propertyKeyId, existingPropertyKeyIds, value);
    }

    void onPropertyChange(NodeCursor node, PropertyCursor propertyCursor, long[] labels, int propertyKeyId, int[] existingPropertyKeyIds, Value beforeValue, Value afterValue) {
        this.onPropertyChange(new NodeCursorWrapper(node), propertyCursor, labels, propertyKeyId, existingPropertyKeyIds, beforeValue, afterValue);
    }

    void onPropertyAdd(RelationshipScanCursor relationship, PropertyCursor propertyCursor, int type, int propertyKeyId, int[] existingPropertyKeyIds, Value value) {
        this.onPropertyAdd(new RelationshipCursorWrapper(relationship), propertyCursor, new long[]{type}, propertyKeyId, existingPropertyKeyIds, value);
    }

    void onPropertyRemove(RelationshipScanCursor relationship, PropertyCursor propertyCursor, int type, int propertyKeyId, int[] existingPropertyKeyIds, Value value) {
        this.onPropertyRemove(new RelationshipCursorWrapper(relationship), propertyCursor, new long[]{type}, propertyKeyId, existingPropertyKeyIds, value);
    }

    void onPropertyChange(RelationshipScanCursor relationship, PropertyCursor propertyCursor, int type, int propertyKeyId, int[] existingPropertyKeyIds, Value beforeValue, Value afterValue) {
        this.onPropertyChange(new RelationshipCursorWrapper(relationship), propertyCursor, new long[]{type}, propertyKeyId, existingPropertyKeyIds, beforeValue, afterValue);
    }

    void onDeleteUncreated(NodeCursor node, PropertyCursor propertyCursor) {
        this.onDeleteUncreated(new NodeCursorWrapper(node), propertyCursor, node.labels().all());
    }

    void onDeleteUncreated(RelationshipScanCursor relationship, PropertyCursor propertyCursor) {
        this.onDeleteUncreated(new RelationshipCursorWrapper(relationship), propertyCursor, new long[]{relationship.type()});
    }

    private boolean noSchemaChangedInTx() {
        return !this.read.txState().hasChanges() || this.read.txState().hasDataChanges();
    }

    private void onDeleteUncreated(EntityCursor entity, PropertyCursor propertyCursor, long[] tokens) {
        assert (this.noSchemaChangedInTx());
        entity.properties(propertyCursor);
        MutableIntList propertyKeyList = IntLists.mutable.empty();
        while (propertyCursor.next()) {
            propertyKeyList.add(propertyCursor.propertyKey());
        }
        int[] propertyKeyIds = propertyKeyList.toArray();
        Collection indexes = this.storageReader.valueIndexesGetRelated(tokens, propertyKeyIds, entity.entityType());
        if (!indexes.isEmpty()) {
            MutableIntObjectMap materializedProperties = IntObjectMaps.mutable.empty();
            SchemaMatcher.onMatchingSchema(indexes.iterator(), -1, propertyKeyIds, index -> {
                MemoryTracker memoryTracker = this.read.txState().memoryTracker();
                SchemaDescriptor schema = index.schema();
                Value[] values = IndexTxStateUpdater.getValueTuple(entity, propertyCursor, -1, Values.NO_VALUE, schema.getPropertyIds(), (MutableIntObjectMap<Value>)materializedProperties, memoryTracker);
                ValueTuple valueTuple = ValueTuple.of((Value[])values);
                memoryTracker.allocateHeap(valueTuple.getShallowSize());
                this.read.txState().indexDoUpdateEntry(schema, entity.reference(), valueTuple, null);
            });
        }
    }

    private void onPropertyAdd(EntityCursor entity, PropertyCursor propertyCursor, long[] tokens, int propertyKeyId, int[] existingPropertyKeyIds, Value value) {
        assert (this.noSchemaChangedInTx());
        Collection indexes = this.storageReader.valueIndexesGetRelated(tokens, propertyKeyId, entity.entityType());
        if (!indexes.isEmpty()) {
            MutableIntObjectMap materializedProperties = IntObjectMaps.mutable.empty();
            SchemaMatcher.onMatchingSchema(indexes.iterator(), propertyKeyId, existingPropertyKeyIds, index -> {
                MemoryTracker memoryTracker = this.read.txState().memoryTracker();
                SchemaDescriptor schema = index.schema();
                Value[] values = IndexTxStateUpdater.getValueTuple(entity, propertyCursor, propertyKeyId, value, schema.getPropertyIds(), (MutableIntObjectMap<Value>)materializedProperties, memoryTracker);
                this.indexingService.validateBeforeCommit((IndexDescriptor)index, values, entity.reference());
                ValueTuple valueTuple = ValueTuple.of((Value[])values);
                memoryTracker.allocateHeap(valueTuple.getShallowSize());
                this.read.txState().indexDoUpdateEntry(schema, entity.reference(), null, valueTuple);
            });
        }
    }

    private void onPropertyRemove(EntityCursor entity, PropertyCursor propertyCursor, long[] tokens, int propertyKeyId, int[] existingPropertyKeyIds, Value value) {
        assert (this.noSchemaChangedInTx());
        Collection indexes = this.storageReader.valueIndexesGetRelated(tokens, propertyKeyId, entity.entityType());
        if (!indexes.isEmpty()) {
            MutableIntObjectMap materializedProperties = IntObjectMaps.mutable.empty();
            SchemaMatcher.onMatchingSchema(indexes.iterator(), propertyKeyId, existingPropertyKeyIds, index -> {
                MemoryTracker memoryTracker = this.read.txState().memoryTracker();
                SchemaDescriptor schema = index.schema();
                Value[] values = IndexTxStateUpdater.getValueTuple(entity, propertyCursor, propertyKeyId, value, schema.getPropertyIds(), (MutableIntObjectMap<Value>)materializedProperties, memoryTracker);
                ValueTuple valueTuple = ValueTuple.of((Value[])values);
                memoryTracker.allocateHeap(valueTuple.getShallowSize());
                this.read.txState().indexDoUpdateEntry(schema, entity.reference(), valueTuple, null);
            });
        }
    }

    private void onPropertyChange(EntityCursor entity, PropertyCursor propertyCursor, long[] tokens, int propertyKeyId, int[] existingPropertyKeyIds, Value beforeValue, Value afterValue) {
        assert (this.noSchemaChangedInTx());
        Collection indexes = this.storageReader.valueIndexesGetRelated(tokens, propertyKeyId, entity.entityType());
        if (!indexes.isEmpty()) {
            MutableIntObjectMap materializedProperties = IntObjectMaps.mutable.empty();
            SchemaMatcher.onMatchingSchema(indexes.iterator(), propertyKeyId, existingPropertyKeyIds, index -> {
                MemoryTracker memoryTracker = this.read.txState().memoryTracker();
                SchemaDescriptor schema = index.schema();
                int[] propertyIds = schema.getPropertyIds();
                Value[] valuesAfter = IndexTxStateUpdater.getValueTuple(entity, propertyCursor, propertyKeyId, afterValue, propertyIds, (MutableIntObjectMap<Value>)materializedProperties, memoryTracker);
                Value[] valuesBefore = Arrays.copyOf(valuesAfter, valuesAfter.length);
                int k = ArrayUtils.indexOf((int[])propertyIds, (int)propertyKeyId);
                valuesBefore[k] = beforeValue;
                this.indexingService.validateBeforeCommit((IndexDescriptor)index, valuesAfter, entity.reference());
                ValueTuple valuesTupleBefore = ValueTuple.of((Value[])valuesBefore);
                ValueTuple valuesTupleAfter = ValueTuple.of((Value[])valuesAfter);
                memoryTracker.allocateHeap(valuesTupleBefore.getShallowSize() * 2L);
                this.read.txState().indexDoUpdateEntry(schema, entity.reference(), valuesTupleBefore, valuesTupleAfter);
            });
        }
    }

    private static Value[] getValueTuple(EntityCursor entity, PropertyCursor propertyCursor, int changedPropertyKeyId, Value changedValue, int[] indexPropertyIds, MutableIntObjectMap<Value> materializedValues, MemoryTracker memoryTracker) {
        int k;
        Value[] values = new Value[indexPropertyIds.length];
        int missing = 0;
        for (k = 0; k < indexPropertyIds.length; ++k) {
            Value value = values[k] = indexPropertyIds[k] == changedPropertyKeyId ? changedValue : (Value)materializedValues.getIfAbsent(indexPropertyIds[k], (Function0 & Serializable)() -> Values.NO_VALUE);
            if (values[k] != Values.NO_VALUE) continue;
            ++missing;
        }
        if (missing > 0) {
            entity.properties(propertyCursor);
            while (missing > 0 && propertyCursor.next()) {
                k = ArrayUtils.indexOf((int[])indexPropertyIds, (int)propertyCursor.propertyKey());
                if (k < 0 || values[k] != Values.NO_VALUE) continue;
                int propertyKeyId = indexPropertyIds[k];
                boolean thisIsTheChangedProperty = propertyKeyId == changedPropertyKeyId;
                Value value = values[k] = thisIsTheChangedProperty ? changedValue : propertyCursor.propertyValue();
                if (!thisIsTheChangedProperty) {
                    materializedValues.put(propertyKeyId, (Object)values[k]);
                    memoryTracker.allocateHeap(values[k].estimatedHeapUsage());
                }
                --missing;
            }
        }
        return values;
    }

    private static class RelationshipCursorWrapper
    implements EntityCursor {
        private final RelationshipScanCursor relationship;

        private RelationshipCursorWrapper(RelationshipScanCursor relationship) {
            this.relationship = relationship;
        }

        @Override
        public long reference() {
            return this.relationship.relationshipReference();
        }

        @Override
        public void properties(PropertyCursor cursor) {
            this.relationship.properties(cursor);
        }

        @Override
        public EntityType entityType() {
            return EntityType.RELATIONSHIP;
        }
    }

    private static class NodeCursorWrapper
    implements EntityCursor {
        private final NodeCursor node;

        private NodeCursorWrapper(NodeCursor node) {
            this.node = node;
        }

        @Override
        public long reference() {
            return this.node.nodeReference();
        }

        @Override
        public void properties(PropertyCursor cursor) {
            this.node.properties(cursor);
        }

        @Override
        public EntityType entityType() {
            return EntityType.NODE;
        }
    }

    private static interface EntityCursor {
        public long reference();

        public void properties(PropertyCursor var1);

        public EntityType entityType();
    }

    public static enum LabelChangeType {
        ADDED_LABEL,
        REMOVED_LABEL;

    }
}

