/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotApplicableKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceIds;
import org.neo4j.kernel.impl.newapi.IndexReaders;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.ResourceType;
import org.neo4j.lock.ResourceTypes;

public class LockingNodeUniqueIndexSeek {
    public static <CURSOR extends NodeValueIndexCursor> long apply(Locks.Client locks, LockTracer lockTracer, CURSOR cursor, UniqueNodeIndexSeeker<CURSOR> nodeIndexSeeker, Read read, IndexDescriptor index, PropertyIndexQuery.ExactPredicate ... predicates) throws IndexNotApplicableKernelException, IndexNotFoundKernelException {
        int[] entityTokenIds = index.schema().getEntityTokenIds();
        if (entityTokenIds.length != 1) {
            throw new IndexNotApplicableKernelException("Multi-token index " + index + " does not support uniqueness.");
        }
        long indexEntryId = ResourceIds.indexEntryResourceId(entityTokenIds[0], predicates);
        locks.acquireShared(lockTracer, (ResourceType)ResourceTypes.INDEX_ENTRY, new long[]{indexEntryId});
        try (IndexReaders readers = new IndexReaders(index, read);){
            nodeIndexSeeker.nodeIndexSeekWithFreshIndexReader(cursor, readers.createReader(), predicates);
            if (!cursor.next()) {
                locks.releaseShared((ResourceType)ResourceTypes.INDEX_ENTRY, new long[]{indexEntryId});
                locks.acquireExclusive(lockTracer, (ResourceType)ResourceTypes.INDEX_ENTRY, new long[]{indexEntryId});
                nodeIndexSeeker.nodeIndexSeekWithFreshIndexReader(cursor, readers.createReader(), predicates);
                if (cursor.next()) {
                    locks.acquireShared(lockTracer, (ResourceType)ResourceTypes.INDEX_ENTRY, new long[]{indexEntryId});
                    locks.releaseExclusive((ResourceType)ResourceTypes.INDEX_ENTRY, new long[]{indexEntryId});
                    long l = cursor.nodeReference();
                    return l;
                }
                long l = -1L;
                return l;
            }
            long l = cursor.nodeReference();
            return l;
        }
    }

    @FunctionalInterface
    static interface UniqueNodeIndexSeeker<CURSOR extends NodeValueIndexCursor> {
        public void nodeIndexSeekWithFreshIndexReader(CURSOR var1, ValueIndexReader var2, PropertyIndexQuery.ExactPredicate ... var3) throws IndexNotApplicableKernelException;
    }
}

