/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.StringJoiner;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.Type;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;

class DurationType
extends Type {
    DurationType(byte typeId) {
        super(ValueGroup.DURATION, typeId, (Value)DurationValue.MIN_VALUE, (Value)DurationValue.MAX_VALUE);
    }

    @Override
    int valueSize(GenericKey state) {
        return 28;
    }

    @Override
    void copyValue(GenericKey to, GenericKey from) {
        to.long0 = from.long0;
        to.long1 = from.long1;
        to.long2 = from.long2;
        to.long3 = from.long3;
    }

    @Override
    Value asValue(GenericKey state) {
        return DurationType.asValue(state.long0, state.long1, state.long2, state.long3);
    }

    @Override
    int compareValue(GenericKey left, GenericKey right) {
        return DurationType.compare(left.long0, left.long1, left.long2, left.long3, right.long0, right.long1, right.long2, right.long3);
    }

    @Override
    void putValue(PageCursor cursor, GenericKey state) {
        DurationType.put(cursor, state.long0, state.long1, state.long2, state.long3);
    }

    @Override
    boolean readValue(PageCursor cursor, int size, GenericKey into) {
        return DurationType.read(cursor, into);
    }

    static DurationValue asValue(long long0, long long1, long long2, long long3) {
        long seconds = long0 - long2 * 2629800L - long3 * 86400L;
        return DurationValue.duration((long)long2, (long)long3, (long)seconds, (long)long1);
    }

    static int compare(long this_long0, long this_long1, long this_long2, long this_long3, long that_long0, long that_long1, long that_long2, long that_long3) {
        int comparison = Long.compare(this_long0, that_long0);
        if (comparison == 0 && (comparison = Integer.compare((int)this_long1, (int)that_long1)) == 0 && (comparison = Long.compare(this_long2, that_long2)) == 0) {
            comparison = Long.compare(this_long3, that_long3);
        }
        return comparison;
    }

    static void put(PageCursor cursor, long long0, long long1, long long2, long long3) {
        cursor.putLong(long0);
        cursor.putInt((int)long1);
        cursor.putLong(long2);
        cursor.putLong(long3);
    }

    static boolean read(PageCursor cursor, GenericKey into) {
        long totalAvgSeconds = cursor.getLong();
        int nanosOfSecond = cursor.getInt();
        long months = cursor.getLong();
        long days = cursor.getLong();
        into.writeDurationWithTotalAvgSeconds(months, days, totalAvgSeconds, nanosOfSecond);
        return true;
    }

    static void write(GenericKey state, long months, long days, long totalAvgSeconds, int nanos) {
        state.long0 = totalAvgSeconds;
        state.long1 = nanos;
        state.long2 = months;
        state.long3 = days;
    }

    @Override
    protected void addTypeSpecificDetails(StringJoiner joiner, GenericKey state) {
        joiner.add("long0=" + state.long0);
        joiner.add("long1=" + state.long1);
        joiner.add("long2=" + state.long2);
        joiner.add("long3=" + state.long3);
    }
}

