/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.monitoring;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.neo4j.graphdb.event.DatabaseEventContext;
import org.neo4j.graphdb.event.DatabaseEventListener;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.monitoring.DefaultDatabaseEvent;
import org.neo4j.kernel.monitoring.PanicDatabaseEvent;
import org.neo4j.logging.Log;

public class DatabaseEventListeners {
    private final List<DatabaseEventListener> databaseEventListeners = new CopyOnWriteArrayList<DatabaseEventListener>();
    private final Log log;

    public DatabaseEventListeners(Log log) {
        this.log = log;
    }

    public void registerDatabaseEventListener(DatabaseEventListener listener) {
        DatabaseEventListeners.addListener(listener, this.databaseEventListeners);
    }

    public void unregisterDatabaseEventListener(DatabaseEventListener listener) {
        DatabaseEventListeners.removeListener(listener, this.databaseEventListeners);
    }

    private static <T> void addListener(T listener, List<T> listeners) {
        if (listeners.contains(listener)) {
            return;
        }
        listeners.add(listener);
    }

    private static <T> void removeListener(T listener, List<T> listeners) {
        if (!listeners.remove(listener)) {
            throw new IllegalStateException("Database listener `" + listener + "` is not registered.");
        }
    }

    public void databaseStart(NamedDatabaseId databaseId) {
        DefaultDatabaseEvent event = new DefaultDatabaseEvent(databaseId);
        this.notifyEventListeners(handler -> handler.databaseStart((DatabaseEventContext)event), this.databaseEventListeners);
    }

    public void databaseShutdown(NamedDatabaseId databaseId) {
        DefaultDatabaseEvent event = new DefaultDatabaseEvent(databaseId);
        this.notifyEventListeners(handler -> handler.databaseShutdown((DatabaseEventContext)event), this.databaseEventListeners);
    }

    public void databaseCreate(NamedDatabaseId databaseId) {
        DefaultDatabaseEvent event = new DefaultDatabaseEvent(databaseId);
        this.notifyEventListeners(handler -> handler.databaseCreate((DatabaseEventContext)event), this.databaseEventListeners);
    }

    public void databaseDrop(NamedDatabaseId databaseId) {
        DefaultDatabaseEvent event = new DefaultDatabaseEvent(databaseId);
        this.notifyEventListeners(handler -> handler.databaseDrop((DatabaseEventContext)event), this.databaseEventListeners);
    }

    void databasePanic(NamedDatabaseId databaseId, Throwable causeOfPanic) {
        PanicDatabaseEvent event = new PanicDatabaseEvent(databaseId, causeOfPanic);
        this.notifyEventListeners(handler -> handler.databasePanic((DatabaseEventContext)event), this.databaseEventListeners);
    }

    private <T> void notifyEventListeners(Consumer<T> consumer, List<T> listeners) {
        for (T listener : listeners) {
            try {
                consumer.accept(listener);
            }
            catch (Throwable e) {
                this.log.error("Error while handling database event by listener: " + listener, e);
            }
        }
    }
}

