/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Iterator;
import org.neo4j.common.EntityType;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.Locks;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.Procedures;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.RelationshipTypeIndexCursor;
import org.neo4j.internal.kernel.api.RelationshipValueIndexCursor;
import org.neo4j.internal.kernel.api.Scan;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.TokenPredicate;
import org.neo4j.internal.kernel.api.TokenReadSession;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotApplicableKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.AssertOpen;
import org.neo4j.kernel.api.exceptions.schema.IndexBrokenKernelException;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.api.txstate.TxStateHolder;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.index.schema.TokenScan;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.newapi.DefaultIndexReadSession;
import org.neo4j.kernel.impl.newapi.DefaultNodeCursor;
import org.neo4j.kernel.impl.newapi.DefaultNodeLabelIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultNodeValueIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultPooledCursors;
import org.neo4j.kernel.impl.newapi.DefaultPropertyCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipScanCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipTraversalCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipTypeIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultTokenReadSession;
import org.neo4j.kernel.impl.newapi.EntityIndexSeekClient;
import org.neo4j.kernel.impl.newapi.LockingNodeUniqueIndexSeek;
import org.neo4j.kernel.impl.newapi.NodeCursorScan;
import org.neo4j.kernel.impl.newapi.NodeLabelIndexCursorScan;
import org.neo4j.kernel.impl.newapi.RelationshipCursorScan;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.ResourceType;
import org.neo4j.lock.ResourceTypes;
import org.neo4j.storageengine.api.RelationshipSelection;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;

abstract class Read
implements TxStateHolder,
org.neo4j.internal.kernel.api.Read,
SchemaRead,
Procedures,
Locks,
AssertOpen,
LockingNodeUniqueIndexSeek.UniqueNodeIndexSeeker<DefaultNodeValueIndexCursor>,
QueryContext {
    protected final StorageReader storageReader;
    protected final DefaultPooledCursors cursors;
    final KernelTransactionImplementation ktx;

    Read(StorageReader storageReader, DefaultPooledCursors cursors, KernelTransactionImplementation ktx) {
        this.storageReader = storageReader;
        this.cursors = cursors;
        this.ktx = ktx;
    }

    public final void nodeIndexSeek(IndexReadSession index, NodeValueIndexCursor cursor, IndexQueryConstraints constraints, PropertyIndexQuery ... query) throws IndexNotApplicableKernelException {
        this.ktx.assertOpen();
        DefaultIndexReadSession indexSession = (DefaultIndexReadSession)index;
        if (indexSession.reference.schema().entityType() != EntityType.NODE) {
            throw new IndexNotApplicableKernelException("Node index seek can only be performed on node indexes: " + index.reference().userDescription((TokenNameLookup)this.ktx.tokenRead()));
        }
        EntityIndexSeekClient client = (EntityIndexSeekClient)cursor;
        client.setRead(this);
        indexSession.reader.query((QueryContext)this, (IndexProgressor.EntityValueClient)client, constraints, query);
    }

    public final void relationshipIndexSeek(IndexReadSession index, RelationshipValueIndexCursor cursor, IndexQueryConstraints constraints, PropertyIndexQuery ... query) throws IndexNotApplicableKernelException {
        this.ktx.assertOpen();
        DefaultIndexReadSession indexSession = (DefaultIndexReadSession)index;
        if (indexSession.reference.schema().entityType() != EntityType.RELATIONSHIP) {
            throw new IndexNotApplicableKernelException("Relationship index seek can only be performed on relationship indexes: " + index.reference().userDescription((TokenNameLookup)this.ktx.tokenRead()));
        }
        EntityIndexSeekClient client = (EntityIndexSeekClient)cursor;
        client.setRead(this);
        indexSession.reader.query((QueryContext)this, (IndexProgressor.EntityValueClient)client, constraints, query);
    }

    public org.neo4j.internal.kernel.api.Read getRead() {
        return this;
    }

    public CursorFactory cursors() {
        return this.cursors;
    }

    public ReadableTransactionState getTransactionStateOrNull() {
        return this.hasTxStateWithChanges() ? this.txState() : null;
    }

    public long lockingNodeUniqueIndexSeek(IndexDescriptor index, NodeValueIndexCursor cursor, PropertyIndexQuery.ExactPredicate ... predicates) throws IndexNotApplicableKernelException, IndexNotFoundKernelException, IndexBrokenKernelException {
        this.assertIndexOnline(index);
        Read.assertPredicatesMatchSchema(index, predicates);
        Locks.Client locks = this.ktx.lockClient();
        LockTracer lockTracer = this.ktx.lockTracer();
        return LockingNodeUniqueIndexSeek.apply(locks, lockTracer, (DefaultNodeValueIndexCursor)cursor, this, this, index, predicates);
    }

    @Override
    public void nodeIndexSeekWithFreshIndexReader(DefaultNodeValueIndexCursor cursor, ValueIndexReader indexReader, PropertyIndexQuery.ExactPredicate ... query) throws IndexNotApplicableKernelException {
        cursor.setRead(this);
        indexReader.query((QueryContext)this, (IndexProgressor.EntityValueClient)cursor, IndexQueryConstraints.unconstrained(), (PropertyIndexQuery[])query);
    }

    public final void nodeIndexScan(IndexReadSession index, NodeValueIndexCursor cursor, IndexQueryConstraints constraints) throws KernelException {
        this.ktx.assertOpen();
        DefaultIndexReadSession indexSession = (DefaultIndexReadSession)index;
        if (indexSession.reference.schema().entityType() != EntityType.NODE) {
            throw new IndexNotApplicableKernelException("Node index scan can only be performed on node indexes: " + index.reference().userDescription((TokenNameLookup)this.ktx.tokenRead()));
        }
        this.scanIndex(indexSession, (EntityIndexSeekClient)cursor, constraints);
    }

    public final void relationshipIndexScan(IndexReadSession index, RelationshipValueIndexCursor cursor, IndexQueryConstraints constraints) throws KernelException {
        this.ktx.assertOpen();
        DefaultIndexReadSession indexSession = (DefaultIndexReadSession)index;
        if (indexSession.reference.schema().entityType() != EntityType.RELATIONSHIP) {
            throw new IndexNotApplicableKernelException("Relationship index scan can only be performed on relationship indexes: " + index.reference().userDescription((TokenNameLookup)this.ktx.tokenRead()));
        }
        this.scanIndex(indexSession, (EntityIndexSeekClient)cursor, constraints);
    }

    private void scanIndex(DefaultIndexReadSession indexSession, EntityIndexSeekClient indexSeekClient, IndexQueryConstraints constraints) throws KernelException {
        int firstProperty = indexSession.reference.schema().getPropertyIds()[0];
        indexSeekClient.setRead(this);
        indexSession.reader.query((QueryContext)this, (IndexProgressor.EntityValueClient)indexSeekClient, constraints, new PropertyIndexQuery[]{PropertyIndexQuery.exists((int)firstProperty)});
    }

    public final Scan<NodeLabelIndexCursor> nodeLabelScan(int label) {
        TokenScan tokenScan;
        this.ktx.assertOpen();
        CursorContext cursorContext = this.ktx.cursorContext();
        try {
            Iterator index = this.index((SchemaDescriptor)SchemaDescriptor.forAnyEntityTokens((EntityType)EntityType.NODE));
            if (!index.hasNext()) {
                throw new IndexNotFoundKernelException("There is no index that can back a node label scan.");
            }
            IndexDescriptor nliDescriptor = (IndexDescriptor)index.next();
            DefaultTokenReadSession session = (DefaultTokenReadSession)this.tokenReadSession(nliDescriptor);
            tokenScan = session.reader.entityTokenScan(label, cursorContext);
        }
        catch (IndexNotFoundKernelException e) {
            throw new RuntimeException(e);
        }
        return new NodeLabelIndexCursorScan(this, label, tokenScan, cursorContext);
    }

    public final void nodeLabelScan(TokenReadSession session, NodeLabelIndexCursor cursor, IndexQueryConstraints constraints, TokenPredicate query) throws KernelException {
        this.ktx.assertOpen();
        if (session.reference().schema().entityType() != EntityType.NODE) {
            throw new IndexNotApplicableKernelException("Node label index scan can not be performed on index " + session.reference().userDescription((TokenNameLookup)this.ktx.tokenRead()));
        }
        DefaultTokenReadSession tokenSession = (DefaultTokenReadSession)session;
        DefaultNodeLabelIndexCursor indexCursor = (DefaultNodeLabelIndexCursor)cursor;
        indexCursor.setRead(this);
        tokenSession.reader.query((IndexProgressor.EntityTokenClient)indexCursor, constraints, query, this.ktx.cursorContext());
    }

    public final void allNodesScan(NodeCursor cursor) {
        this.ktx.assertOpen();
        ((DefaultNodeCursor)cursor).scan(this);
    }

    public final Scan<NodeCursor> allNodesScan() {
        this.ktx.assertOpen();
        return new NodeCursorScan(this.storageReader.allNodeScan(), this, this.ktx.cursorContext());
    }

    public final void singleNode(long reference, NodeCursor cursor) {
        this.ktx.assertOpen();
        ((DefaultNodeCursor)cursor).single(reference, this);
    }

    public final void singleRelationship(long reference, RelationshipScanCursor cursor) {
        this.ktx.assertOpen();
        ((DefaultRelationshipScanCursor)cursor).single(reference, this);
    }

    public final void allRelationshipsScan(RelationshipScanCursor cursor) {
        this.ktx.assertOpen();
        ((DefaultRelationshipScanCursor)cursor).scan(this);
    }

    public final Scan<RelationshipScanCursor> allRelationshipsScan() {
        this.ktx.assertOpen();
        return new RelationshipCursorScan(this.storageReader.allRelationshipScan(), this, this.ktx.cursorContext());
    }

    public final void relationshipTypeScan(TokenReadSession session, RelationshipTypeIndexCursor cursor, IndexQueryConstraints constraints, TokenPredicate query) throws KernelException {
        this.ktx.assertOpen();
        if (session.reference().schema().entityType() != EntityType.RELATIONSHIP) {
            throw new IndexNotApplicableKernelException("Relationship type index scan can not be performed on index " + session.reference().userDescription((TokenNameLookup)this.ktx.tokenRead()));
        }
        DefaultTokenReadSession tokenSession = (DefaultTokenReadSession)session;
        DefaultRelationshipTypeIndexCursor indexCursor = (DefaultRelationshipTypeIndexCursor)cursor;
        indexCursor.setRead(this);
        tokenSession.reader.query((IndexProgressor.EntityTokenClient)indexCursor, constraints, query, this.ktx.cursorContext());
    }

    public void relationships(long nodeReference, long reference, RelationshipSelection selection, RelationshipTraversalCursor cursor) {
        ((DefaultRelationshipTraversalCursor)cursor).init(nodeReference, reference, selection, this);
    }

    public void nodeProperties(long nodeReference, long reference, PropertyCursor cursor) {
        ((DefaultPropertyCursor)cursor).initNode(nodeReference, reference, this, (AssertOpen)this.ktx);
    }

    public void relationshipProperties(long relationshipReference, long reference, PropertyCursor cursor) {
        ((DefaultPropertyCursor)cursor).initRelationship(relationshipReference, reference, this, (AssertOpen)this.ktx);
    }

    public abstract ValueIndexReader newValueIndexReader(IndexDescriptor var1) throws IndexNotFoundKernelException;

    @Override
    public TransactionState txState() {
        return this.ktx.txState();
    }

    @Override
    public boolean hasTxStateWithChanges() {
        return this.ktx.hasTxStateWithChanges();
    }

    public void acquireExclusiveNodeLock(long ... ids) {
        this.acquireExclusiveLock(ResourceTypes.NODE_RELATIONSHIP_GROUP_DELETE, ids);
        this.acquireExclusiveLock(ResourceTypes.NODE, ids);
        this.ktx.assertOpen();
    }

    public void acquireExclusiveRelationshipLock(long ... ids) {
        this.acquireExclusiveLock(ResourceTypes.RELATIONSHIP_DELETE, ids);
        this.acquireExclusiveLock(ResourceTypes.RELATIONSHIP, ids);
        this.ktx.assertOpen();
    }

    public void releaseExclusiveNodeLock(long ... ids) {
        this.releaseExclusiveLock(ResourceTypes.NODE, ids);
        this.releaseExclusiveLock(ResourceTypes.NODE_RELATIONSHIP_GROUP_DELETE, ids);
        this.ktx.assertOpen();
    }

    public void releaseExclusiveRelationshipLock(long ... ids) {
        this.releaseExclusiveLock(ResourceTypes.RELATIONSHIP, ids);
        this.releaseExclusiveLock(ResourceTypes.RELATIONSHIP_DELETE, ids);
        this.ktx.assertOpen();
    }

    public void acquireSharedNodeLock(long ... ids) {
        this.acquireSharedLock(ResourceTypes.NODE_RELATIONSHIP_GROUP_DELETE, ids);
        this.acquireSharedLock(ResourceTypes.NODE, ids);
        this.ktx.assertOpen();
    }

    public void acquireSharedRelationshipLock(long ... ids) {
        this.acquireSharedLock(ResourceTypes.RELATIONSHIP_DELETE, ids);
        this.acquireSharedLock(ResourceTypes.RELATIONSHIP, ids);
        this.ktx.assertOpen();
    }

    public void acquireSharedRelationshipTypeLock(long ... ids) {
        this.acquireSharedLock(ResourceTypes.RELATIONSHIP_TYPE, ids);
        this.ktx.assertOpen();
    }

    public void acquireSharedLabelLock(long ... ids) {
        this.acquireSharedLock(ResourceTypes.LABEL, ids);
        this.ktx.assertOpen();
    }

    public void releaseSharedNodeLock(long ... ids) {
        this.releaseSharedLock(ResourceTypes.NODE, ids);
        this.releaseSharedLock(ResourceTypes.NODE_RELATIONSHIP_GROUP_DELETE, ids);
        this.ktx.assertOpen();
    }

    public void releaseSharedRelationshipLock(long ... ids) {
        this.releaseSharedLock(ResourceTypes.RELATIONSHIP, ids);
        this.releaseSharedLock(ResourceTypes.RELATIONSHIP_DELETE, ids);
        this.ktx.assertOpen();
    }

    public void releaseSharedLabelLock(long ... ids) {
        this.releaseSharedLock(ResourceTypes.LABEL, ids);
        this.ktx.assertOpen();
    }

    public void releaseSharedRelationshipTypeLock(long ... ids) {
        this.releaseSharedLock(ResourceTypes.RELATIONSHIP_TYPE, ids);
        this.ktx.assertOpen();
    }

    <T extends SchemaDescriptorSupplier> T acquireSharedSchemaLock(T schemaLike) {
        SchemaDescriptor schema = schemaLike.schema();
        long[] lockingKeys = schema.lockingKeys();
        this.ktx.lockClient().acquireShared(this.ktx.lockTracer(), schema.keyType(), lockingKeys);
        return schemaLike;
    }

    <T extends SchemaDescriptorSupplier> void releaseSharedSchemaLock(T schemaLike) {
        SchemaDescriptor schema = schemaLike.schema();
        long[] lockingKeys = schema.lockingKeys();
        this.ktx.lockClient().releaseShared(schema.keyType(), lockingKeys);
    }

    void acquireSharedLock(ResourceType resource, long resourceId) {
        this.ktx.lockClient().acquireShared(this.ktx.lockTracer(), resource, new long[]{resourceId});
    }

    private void acquireExclusiveLock(ResourceTypes types, long ... ids) {
        this.ktx.lockClient().acquireExclusive(this.ktx.lockTracer(), (ResourceType)types, ids);
    }

    private void releaseExclusiveLock(ResourceTypes types, long ... ids) {
        this.ktx.lockClient().releaseExclusive((ResourceType)types, ids);
    }

    private void acquireSharedLock(ResourceTypes types, long ... ids) {
        this.ktx.lockClient().acquireShared(this.ktx.lockTracer(), (ResourceType)types, ids);
    }

    private void releaseSharedLock(ResourceTypes types, long ... ids) {
        this.ktx.lockClient().releaseShared((ResourceType)types, ids);
    }

    private void assertIndexOnline(IndexDescriptor index) throws IndexNotFoundKernelException, IndexBrokenKernelException {
        if (this.indexGetState(index) == InternalIndexState.ONLINE) {
            return;
        }
        throw new IndexBrokenKernelException(this.indexGetFailure(index));
    }

    private static void assertPredicatesMatchSchema(IndexDescriptor index, PropertyIndexQuery.ExactPredicate[] predicates) throws IndexNotApplicableKernelException {
        int[] propertyIds = index.schema().getPropertyIds();
        if (propertyIds.length != predicates.length) {
            throw new IndexNotApplicableKernelException(String.format("The index specifies %d properties, but only %d lookup predicates were given.", propertyIds.length, predicates.length));
        }
        for (int i = 0; i < predicates.length; ++i) {
            if (predicates[i].propertyKeyId() == propertyIds[i]) continue;
            throw new IndexNotApplicableKernelException(String.format("The index has the property id %d in position %d, but the lookup property id was %d.", propertyIds[i], i, predicates[i].propertyKeyId()));
        }
    }

    public void assertOpen() {
        this.ktx.assertOpen();
    }

    public void acquireSharedLookupLock(EntityType entityType) {
        this.acquireSharedSchemaLock(SchemaDescriptor.forAnyEntityTokens((EntityType)entityType));
        this.ktx.assertOpen();
    }

    public void releaseSharedLookupLock(EntityType entityType) {
        this.releaseSharedSchemaLock(SchemaDescriptor.forAnyEntityTokens((EntityType)entityType));
        this.ktx.assertOpen();
    }
}

