/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.collections.api.iterator.LongIterator;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.helpers.DatabaseNameValidator;
import org.neo4j.dbms.api.DatabaseManagementException;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.api.DatabaseNotFoundException;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseManager;
import org.neo4j.dbms.database.SystemGraphDbmsModel;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.event.DatabaseEventListener;
import org.neo4j.graphdb.event.TransactionEventListener;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.availability.CompositeDatabaseAvailabilityGuard;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.internal.event.GlobalTransactionEventListeners;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.DatabaseEventListeners;
import org.neo4j.logging.Log;
import org.neo4j.storageengine.api.txstate.NodeState;
import org.neo4j.token.TokenHolders;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class DatabaseManagementServiceImpl
implements DatabaseManagementService {
    private static final SystemDatabaseExecutionContext NO_COMMIT_HOOK = (db, tx) -> {};
    private final DatabaseManager<?> databaseManager;
    private final CompositeDatabaseAvailabilityGuard globalAvailabilityGuard;
    private final Lifecycle globalLife;
    private final DatabaseEventListeners databaseEventListeners;
    private final GlobalTransactionEventListeners transactionEventListeners;
    private final Log log;
    private final Config globalConfig;

    public DatabaseManagementServiceImpl(DatabaseManager<?> databaseManager, CompositeDatabaseAvailabilityGuard globalAvailabilityGuard, Lifecycle globalLife, DatabaseEventListeners databaseEventListeners, GlobalTransactionEventListeners transactionEventListeners, Log log, Config globalConfig) {
        this.databaseManager = databaseManager;
        this.globalAvailabilityGuard = globalAvailabilityGuard;
        this.globalLife = globalLife;
        this.databaseEventListeners = databaseEventListeners;
        this.transactionEventListeners = transactionEventListeners;
        this.log = log;
        this.globalConfig = globalConfig;
    }

    public GraphDatabaseService database(String name) throws DatabaseNotFoundException {
        return ((DatabaseContext)this.databaseManager.getDatabaseContext(name).orElseThrow(() -> new DatabaseNotFoundException(name))).databaseFacade();
    }

    public void createDatabase(String name, Configuration databaseSpecificSettings) {
        String storageEngineName = this.getStorageEngine(databaseSpecificSettings);
        this.systemDatabaseExecute("CREATE DATABASE `" + name + "`", (database, transaction) -> {
            TransactionState txState = ((KernelTransactionImplementation)transaction.kernelTransaction()).txState();
            TokenHolders tokenHolders = (TokenHolders)database.getDependencyResolver().resolveDependency(TokenHolders.class);
            long nodeId = this.findNodeForCreatedDatabaseInTransactionState(txState, tokenHolders, name);
            int storageEngineNamePropertyKeyTokenId = tokenHolders.propertyKeyTokens().getOrCreateId("storage_engine");
            txState.nodeDoAddProperty(nodeId, storageEngineNamePropertyKeyTokenId, (Value)Values.stringValue((String)storageEngineName));
        });
    }

    private String getStorageEngine(Configuration databaseSpecificSettings) {
        String dbSpecificStorageEngineName = (String)databaseSpecificSettings.get(GraphDatabaseInternalSettings.storage_engine);
        return dbSpecificStorageEngineName != null ? dbSpecificStorageEngineName : (String)this.globalConfig.get(GraphDatabaseInternalSettings.storage_engine);
    }

    private long findNodeForCreatedDatabaseInTransactionState(TransactionState txState, TokenHolders tokenHolders, String name) {
        int databaseLabelTokenId = tokenHolders.labelTokens().getIdByName(SystemGraphDbmsModel.DATABASE_LABEL.name());
        int databaseNamePropertyKeyTokenId = tokenHolders.propertyKeyTokens().getIdByName("name");
        LongIterator addedNodes = txState.addedAndRemovedNodes().getAdded().longIterator();
        while (addedNodes.hasNext()) {
            long nodeId = addedNodes.next();
            NodeState nodeState = txState.getNodeState(nodeId);
            String validatedName = DatabaseNameValidator.validateDatabaseNamePattern((String)name);
            if (!nodeState.labelDiffSets().isAdded((long)databaseLabelTokenId) || !validatedName.equals(nodeState.propertyValue(databaseNamePropertyKeyTokenId).asObjectCopy().toString())) continue;
            return nodeId;
        }
        throw new IllegalStateException("Couldn't find the node representing the created database '" + name + "'");
    }

    public void dropDatabase(String name) {
        this.systemDatabaseExecute("DROP DATABASE `" + name + "`");
    }

    public void startDatabase(String name) {
        this.systemDatabaseExecute("START DATABASE `" + name + "`");
    }

    public void shutdownDatabase(String name) {
        this.systemDatabaseExecute("STOP DATABASE `" + name + "`");
    }

    public List<String> listDatabases() {
        return this.databaseManager.registeredDatabases().keySet().stream().map(NamedDatabaseId::name).sorted().collect(Collectors.toList());
    }

    public void registerDatabaseEventListener(DatabaseEventListener listener) {
        this.databaseEventListeners.registerDatabaseEventListener(listener);
    }

    public void unregisterDatabaseEventListener(DatabaseEventListener listener) {
        this.databaseEventListeners.unregisterDatabaseEventListener(listener);
    }

    public void registerTransactionEventListener(String databaseName, TransactionEventListener<?> listener) {
        DatabaseManagementServiceImpl.validateDatabaseName(databaseName);
        this.transactionEventListeners.registerTransactionEventListener(databaseName, listener);
    }

    public void unregisterTransactionEventListener(String databaseName, TransactionEventListener<?> listener) {
        this.transactionEventListeners.unregisterTransactionEventListener(databaseName, listener);
    }

    public void shutdown() {
        try {
            this.log.info("Shutdown started");
            this.globalAvailabilityGuard.shutdown();
            this.globalLife.shutdown();
        }
        catch (Exception throwable) {
            String message = "Shutdown failed";
            this.log.error(message, (Throwable)throwable);
            throw new RuntimeException(message, throwable);
        }
    }

    private void systemDatabaseExecute(String query) {
        this.systemDatabaseExecute(query, NO_COMMIT_HOOK);
    }

    private void systemDatabaseExecute(String query, SystemDatabaseExecutionContext beforeCommitHook) {
        try {
            GraphDatabaseAPI database = (GraphDatabaseAPI)this.database("system");
            try (InternalTransaction transaction = database.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED);){
                transaction.execute(query);
                beforeCommitHook.accept(database, transaction);
                transaction.commit();
            }
        }
        catch (KernelException | QueryExecutionException e) {
            throw new DatabaseManagementException(e);
        }
    }

    private static void validateDatabaseName(String databaseName) {
        if ("system".equals(databaseName)) {
            throw new IllegalArgumentException("Registration of transaction event listeners on system is not supported.");
        }
    }

    private static interface SystemDatabaseExecutionContext {
        public void accept(GraphDatabaseAPI var1, InternalTransaction var2) throws KernelException;
    }
}

