/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.dbstructure;

import java.util.Iterator;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.helpers.collection.Visitable;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.constraints.NodeExistenceConstraintDescriptor;
import org.neo4j.internal.schema.constraints.NodeKeyConstraintDescriptor;
import org.neo4j.internal.schema.constraints.RelExistenceConstraintDescriptor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.util.dbstructure.DbStructureVisitor;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public class GraphDbStructureGuide
implements Visitable<DbStructureVisitor> {
    private static final RelationshipType WILDCARD_REL_TYPE = () -> "";
    private final GraphDatabaseAPI db;

    public GraphDbStructureGuide(GraphDatabaseService graph) {
        this.db = (GraphDatabaseAPI)graph;
    }

    public void accept(DbStructureVisitor visitor) {
        try (Transaction tx = this.db.beginTx();){
            GraphDbStructureGuide.showStructure((InternalTransaction)tx, visitor);
            tx.commit();
        }
    }

    private static void showStructure(InternalTransaction transaction, DbStructureVisitor visitor) {
        try {
            GraphDbStructureGuide.showTokens(visitor, transaction);
            GraphDbStructureGuide.showSchema(visitor, transaction.kernelTransaction());
            GraphDbStructureGuide.showStatistics(visitor, transaction);
        }
        catch (KernelException e) {
            throw new IllegalStateException("Kernel exception when traversing database schema structure and statistics. This is not expected to happen.", e);
        }
    }

    private static void showTokens(DbStructureVisitor visitor, InternalTransaction transaction) {
        GraphDbStructureGuide.showLabels(transaction, visitor);
        GraphDbStructureGuide.showPropertyKeys(transaction, visitor);
        GraphDbStructureGuide.showRelTypes(transaction, visitor);
    }

    private static void showLabels(InternalTransaction transaction, DbStructureVisitor visitor) {
        for (Label label : transaction.getAllLabels()) {
            int labelId = transaction.kernelTransaction().tokenRead().nodeLabel(label.name());
            visitor.visitLabel(labelId, label.name());
        }
    }

    private static void showPropertyKeys(InternalTransaction transaction, DbStructureVisitor visitor) {
        for (String propertyKeyName : transaction.getAllPropertyKeys()) {
            int propertyKeyId = transaction.kernelTransaction().tokenRead().propertyKey(propertyKeyName);
            visitor.visitPropertyKey(propertyKeyId, propertyKeyName);
        }
    }

    private static void showRelTypes(InternalTransaction transaction, DbStructureVisitor visitor) {
        for (RelationshipType relType : transaction.getAllRelationshipTypes()) {
            int relTypeId = transaction.kernelTransaction().tokenRead().relationshipType(relType.name());
            visitor.visitRelationshipType(relTypeId, relType.name());
        }
    }

    private static void showSchema(DbStructureVisitor visitor, KernelTransaction ktx) throws IndexNotFoundKernelException {
        TokenRead nameLookup = ktx.tokenRead();
        GraphDbStructureGuide.showIndices(visitor, ktx, (TokenNameLookup)nameLookup);
        GraphDbStructureGuide.showUniqueConstraints(visitor, ktx, (TokenNameLookup)nameLookup);
    }

    private static void showIndices(DbStructureVisitor visitor, KernelTransaction ktx, TokenNameLookup nameLookup) throws IndexNotFoundKernelException {
        SchemaRead schemaRead = ktx.schemaRead();
        for (IndexDescriptor reference : Iterators.loop((Iterator)IndexDescriptor.sortByType((Iterator)schemaRead.indexesGetAll()))) {
            String userDescription = reference.schema().userDescription(nameLookup);
            double uniqueValuesPercentage = schemaRead.indexUniqueValuesSelectivity(reference);
            long size = schemaRead.indexSize(reference);
            visitor.visitIndex(reference, userDescription, uniqueValuesPercentage, size);
        }
    }

    private static void showUniqueConstraints(DbStructureVisitor visitor, KernelTransaction ktx, TokenNameLookup nameLookup) {
        Iterator constraints = ktx.schemaRead().constraintsGetAll();
        while (constraints.hasNext()) {
            NodeExistenceConstraintDescriptor existenceConstraint;
            ConstraintDescriptor constraint = (ConstraintDescriptor)constraints.next();
            String userDescription = constraint.userDescription(nameLookup);
            if (constraint.isUniquenessConstraint()) {
                visitor.visitUniqueConstraint(constraint.asUniquenessConstraint(), userDescription);
                continue;
            }
            if (constraint.isNodePropertyExistenceConstraint()) {
                existenceConstraint = constraint.asNodePropertyExistenceConstraint();
                visitor.visitNodePropertyExistenceConstraint(existenceConstraint, userDescription);
                continue;
            }
            if (constraint.isRelationshipPropertyExistenceConstraint()) {
                existenceConstraint = constraint.asRelationshipPropertyExistenceConstraint();
                visitor.visitRelationshipPropertyExistenceConstraint((RelExistenceConstraintDescriptor)existenceConstraint, userDescription);
                continue;
            }
            if (constraint.isNodeKeyConstraint()) {
                NodeKeyConstraintDescriptor nodeKeyConstraint = constraint.asNodeKeyConstraint();
                visitor.visitNodeKeyConstraint(nodeKeyConstraint, userDescription);
                continue;
            }
            throw new IllegalArgumentException("Unknown constraint type: " + constraint.getClass() + ", constraint: " + constraint);
        }
    }

    private static void showStatistics(DbStructureVisitor visitor, InternalTransaction transaction) {
        GraphDbStructureGuide.showNodeCounts(transaction, visitor);
        GraphDbStructureGuide.showRelCounts(transaction, visitor);
    }

    private static void showNodeCounts(InternalTransaction transaction, DbStructureVisitor visitor) {
        KernelTransaction kernelTransaction = transaction.kernelTransaction();
        Read read = kernelTransaction.dataRead();
        visitor.visitAllNodesCount(read.countsForNode(-1));
        for (Label label : transaction.getAllLabels()) {
            int labelId = kernelTransaction.tokenRead().nodeLabel(label.name());
            visitor.visitNodeCount(labelId, label.name(), read.countsForNode(labelId));
        }
    }

    private static void showRelCounts(InternalTransaction transaction, DbStructureVisitor visitor) {
        KernelTransaction ktx = transaction.kernelTransaction();
        GraphDbStructureGuide.noSide(ktx, visitor, WILDCARD_REL_TYPE, -1);
        TokenRead tokenRead = ktx.tokenRead();
        for (Label label : transaction.getAllLabels()) {
            int labelId = tokenRead.nodeLabel(label.name());
            GraphDbStructureGuide.leftSide(ktx, visitor, label, labelId, WILDCARD_REL_TYPE, -1);
            GraphDbStructureGuide.rightSide(ktx, visitor, label, labelId, WILDCARD_REL_TYPE, -1);
        }
        for (RelationshipType relType : transaction.getAllRelationshipTypes()) {
            int relTypeId = tokenRead.relationshipType(relType.name());
            GraphDbStructureGuide.noSide(ktx, visitor, relType, relTypeId);
            for (Label label : transaction.getAllLabels()) {
                int labelId = tokenRead.nodeLabel(label.name());
                GraphDbStructureGuide.leftSide(ktx, visitor, label, labelId, relType, relTypeId);
                GraphDbStructureGuide.rightSide(ktx, visitor, label, labelId, relType, relTypeId);
            }
        }
    }

    private static void noSide(KernelTransaction ktx, DbStructureVisitor visitor, RelationshipType relType, int relTypeId) {
        String userDescription = String.format("MATCH ()-[%s]->() RETURN count(*)", GraphDbStructureGuide.colon(relType.name()));
        long amount = ktx.dataRead().countsForRelationship(-1, relTypeId, -1);
        visitor.visitRelCount(-1, relTypeId, -1, userDescription, amount);
    }

    private static void leftSide(KernelTransaction ktx, DbStructureVisitor visitor, Label label, int labelId, RelationshipType relType, int relTypeId) {
        String userDescription = String.format("MATCH (%s)-[%s]->() RETURN count(*)", GraphDbStructureGuide.colon(label.name()), GraphDbStructureGuide.colon(relType.name()));
        long amount = ktx.dataRead().countsForRelationship(labelId, relTypeId, -1);
        visitor.visitRelCount(labelId, relTypeId, -1, userDescription, amount);
    }

    private static void rightSide(KernelTransaction ktx, DbStructureVisitor visitor, Label label, int labelId, RelationshipType relType, int relTypeId) {
        String userDescription = String.format("MATCH ()-[%s]->(%s) RETURN count(*)", GraphDbStructureGuide.colon(relType.name()), GraphDbStructureGuide.colon(label.name()));
        long amount = ktx.dataRead().countsForRelationship(-1, relTypeId, labelId);
        visitor.visitRelCount(-1, relTypeId, labelId, userDescription, amount);
    }

    private static String colon(String name) {
        return name.isEmpty() ? name : ":" + name;
    }
}

