/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.query;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.kernel.api.query.IndexUsage;

public class RelationshipTypeIndexUsage
extends IndexUsage {
    private final String relType;
    private final String[] propertyKeys;
    private final int[] propertyKeyIds;
    private final int relTypeId;

    public RelationshipTypeIndexUsage(String identifier, int relTypeId, String relType, int[] propertyKeyIds, String[] propertyKeys) {
        super(identifier);
        this.relType = relType;
        this.relTypeId = relTypeId;
        this.propertyKeys = propertyKeys;
        this.propertyKeyIds = propertyKeyIds;
    }

    public int getRelationshipTypeId() {
        return this.relTypeId;
    }

    public int[] getPropertyKeyIds() {
        return this.propertyKeyIds;
    }

    @Override
    public Map<String, String> asMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("indexType", "SCHEMA INDEX");
        map.put("entityType", "RELATIONSHIP");
        map.put("identifier", this.identifier);
        map.put("relationshipType", this.relType);
        map.put("relationshipTypeId", String.valueOf(this.relTypeId));
        for (int i = 0; i < this.propertyKeys.length; ++i) {
            Object key = this.propertyKeys.length > 1 ? "propertyKey_" + i : "propertyKey";
            map.put((String)key, this.propertyKeys[i]);
        }
        return map;
    }
}

