/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.impl.index.schema.NativeHitIndexProgressor;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.values.storable.Value;

class FilteringNativeHitIndexProgressor<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue>
extends NativeHitIndexProgressor<KEY, VALUE> {
    private final PropertyIndexQuery[] filter;

    FilteringNativeHitIndexProgressor(Seeker<KEY, VALUE> seeker, IndexProgressor.EntityValueClient client, PropertyIndexQuery[] filter) {
        super(seeker, client);
        this.filter = filter;
    }

    @Override
    protected boolean acceptValue(Value[] values) {
        for (int i = 0; i < values.length; ++i) {
            if (this.filter[i].acceptsValue(values[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    Value[] extractValues(KEY key) {
        return ((NativeIndexKey)((Object)key)).asValues();
    }
}

