/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.rotation;

import java.io.IOException;
import java.nio.file.Path;
import java.time.Clock;
import java.util.function.LongSupplier;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.RotatableFile;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointLogFile;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.kernel.impl.transaction.log.rotation.monitor.LogRotationMonitor;
import org.neo4j.kernel.impl.transaction.tracing.LogRotateEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogRotateEvents;
import org.neo4j.monitoring.Health;
import org.neo4j.util.VisibleForTesting;

public class FileLogRotation
implements LogRotation {
    private final Clock clock;
    private final LogRotationMonitor monitor;
    private final Health databaseHealth;
    private final RotatableFile rotatableFile;
    private long lastRotationCompleted;
    private final LongSupplier lastTransactionIdSupplier;
    private final LongSupplier currentFileVersionSupplier;

    public static LogRotation checkpointLogRotation(CheckpointLogFile checkpointLogFile, LogFile logFile, Clock clock, Health databaseHealth, LogRotationMonitor monitor) {
        return new FileLogRotation(checkpointLogFile, clock, databaseHealth, monitor, () -> logFile.getLogFileInformation().committingEntryId(), IOUtils.uncheckedLongSupplier(checkpointLogFile::getCurrentDetachedLogVersion));
    }

    public static LogRotation transactionLogRotation(LogFiles logFiles, Clock clock, Health databaseHealth, LogRotationMonitor monitor) {
        return new FileLogRotation(logFiles.getLogFile(), clock, databaseHealth, monitor, () -> logFiles.getLogFile().getLogFileInformation().committingEntryId(), logFiles.getLogFile()::getCurrentLogVersion);
    }

    private FileLogRotation(RotatableFile rotatableFile, Clock clock, Health databaseHealth, LogRotationMonitor monitor, LongSupplier lastTransactionIdSupplier, LongSupplier currentFileVersionSupplier) {
        this.clock = clock;
        this.monitor = monitor;
        this.databaseHealth = databaseHealth;
        this.rotatableFile = rotatableFile;
        this.lastTransactionIdSupplier = lastTransactionIdSupplier;
        this.currentFileVersionSupplier = currentFileVersionSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rotateLogIfNeeded(LogRotateEvents logRotateEvents) throws IOException {
        if (this.rotatableFile.rotationNeeded()) {
            RotatableFile rotatableFile = this.rotatableFile;
            synchronized (rotatableFile) {
                if (this.rotatableFile.rotationNeeded()) {
                    this.doRotate(logRotateEvents);
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @VisibleForTesting
    public void rotateLogFile(LogRotateEvents logRotateEvents) throws IOException {
        RotatableFile rotatableFile = this.rotatableFile;
        synchronized (rotatableFile) {
            this.doRotate(logRotateEvents);
        }
    }

    private void doRotate(LogRotateEvents logRotateEvents) throws IOException {
        try (LogRotateEvent rotateEvent = logRotateEvents.beginLogRotate();){
            long currentVersion = this.currentFileVersionSupplier.getAsLong();
            this.databaseHealth.assertHealthy(IOException.class);
            long startTimeMillis = this.clock.millis();
            this.monitor.startRotation(currentVersion);
            Path newLogFile = this.rotatableFile.rotate();
            long lastTransactionId = this.lastTransactionIdSupplier.getAsLong();
            long millisSinceLastRotation = this.lastRotationCompleted == 0L ? 0L : startTimeMillis - this.lastRotationCompleted;
            this.lastRotationCompleted = this.clock.millis();
            long rotationElapsedTime = this.lastRotationCompleted - startTimeMillis;
            rotateEvent.rotationCompleted(rotationElapsedTime);
            this.monitor.finishLogRotation(newLogFile, currentVersion, lastTransactionId, rotationElapsedTime, millisSinceLastRotation);
        }
    }
}

