/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import org.neo4j.kernel.database.LogEntryWriterFactory;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.FlushablePositionAwareChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;
import org.neo4j.util.VisibleForTesting;

public class TransactionLogWriter {
    private final FlushablePositionAwareChecksumChannel channel;
    private final LogEntryWriterFactory logEntryWriterFactory;

    public TransactionLogWriter(FlushablePositionAwareChecksumChannel channel, LogEntryWriterFactory logEntryWriterFactory) {
        this.channel = channel;
        this.logEntryWriterFactory = logEntryWriterFactory;
    }

    public int append(TransactionRepresentation transaction, long transactionId, int previousChecksum) throws IOException {
        LogEntryWriter<FlushablePositionAwareChecksumChannel> writer = this.logEntryWriterFactory.createEntryWriter(this.channel, transaction.version());
        writer.writeStartEntry(transaction.getTimeStarted(), transaction.getLatestCommittedTxWhenStarted(), previousChecksum, transaction.additionalHeader());
        writer.serialize(transaction);
        return writer.writeCommitEntry(transactionId, transaction.getTimeCommitted());
    }

    @VisibleForTesting
    public void legacyCheckPoint(LogPosition logPosition) throws IOException {
        LogEntryWriter<FlushablePositionAwareChecksumChannel> writer = this.logEntryWriterFactory.createEntryWriter(this.channel);
        writer.writeLegacyCheckPointEntry(logPosition);
    }

    public LogPosition getCurrentPosition() throws IOException {
        return this.channel.getCurrentPosition();
    }

    public LogPositionMarker getCurrentPosition(LogPositionMarker logPositionMarker) throws IOException {
        return this.channel.getCurrentPosition(logPositionMarker);
    }

    @VisibleForTesting
    public FlushablePositionAwareChecksumChannel getChannel() {
        return this.channel;
    }

    @VisibleForTesting
    public LogEntryWriter<FlushablePositionAwareChecksumChannel> getWriter() {
        return this.logEntryWriterFactory.createEntryWriter(this.channel);
    }
}

