/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking.forseti;

import org.neo4j.kernel.impl.locking.forseti.ForsetiClient;
import org.neo4j.kernel.impl.locking.forseti.ForsetiLockManager;

public enum DeadlockStrategies implements ForsetiLockManager.DeadlockResolutionStrategy
{
    ABORT_YOUNG{

        @Override
        public boolean shouldAbort(ForsetiClient clientThatsAsking, ForsetiClient clientWereDeadlockedWith) {
            long otherCount;
            if (DeadlockStrategies.isSameClient(clientThatsAsking, clientWereDeadlockedWith)) {
                return true;
            }
            long ourCount = clientThatsAsking.activeLockCount();
            if (ourCount > (otherCount = clientWereDeadlockedWith.activeLockCount())) {
                return false;
            }
            if (otherCount > ourCount) {
                return true;
            }
            return clientThatsAsking.id() >= clientWereDeadlockedWith.id();
        }
    }
    ,
    ABORT_OLD{

        @Override
        public boolean shouldAbort(ForsetiClient clientThatsAsking, ForsetiClient clientWereDeadlockedWith) {
            if (DeadlockStrategies.isSameClient(clientThatsAsking, clientWereDeadlockedWith)) {
                return true;
            }
            return !ABORT_YOUNG.shouldAbort(clientThatsAsking, clientWereDeadlockedWith);
        }
    }
    ,
    ABORT_SHORT_WAIT_LIST{

        @Override
        public boolean shouldAbort(ForsetiClient clientThatsAsking, ForsetiClient clientWereDeadlockedWith) {
            int otherCount;
            if (DeadlockStrategies.isSameClient(clientThatsAsking, clientWereDeadlockedWith)) {
                return true;
            }
            int ourCount = clientThatsAsking.waitListSize();
            if (ourCount > (otherCount = clientWereDeadlockedWith.waitListSize())) {
                return false;
            }
            if (otherCount > ourCount) {
                return true;
            }
            return clientThatsAsking.id() > clientWereDeadlockedWith.id();
        }
    }
    ,
    ABORT_LONG_WAIT_LIST{

        @Override
        public boolean shouldAbort(ForsetiClient clientThatsAsking, ForsetiClient clientWereDeadlockedWith) {
            if (DeadlockStrategies.isSameClient(clientThatsAsking, clientWereDeadlockedWith)) {
                return true;
            }
            return !ABORT_SHORT_WAIT_LIST.shouldAbort(clientThatsAsking, clientWereDeadlockedWith);
        }
    };


    @Override
    public abstract boolean shouldAbort(ForsetiClient var1, ForsetiClient var2);

    private static boolean isSameClient(ForsetiClient a, ForsetiClient b) {
        return a.id() == b.id();
    }
}

