/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.Arrays;
import java.util.StringJoiner;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.AbstractArrayType;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.GeometryType;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.storable.Values;

class GeometryArrayType
extends AbstractArrayType<PointValue> {
    GeometryArrayType(byte typeId) {
        super(ValueGroup.GEOMETRY_ARRAY, typeId, (o1, o2, i) -> GeometryType.compare(o1.long0Array[i], o1.long1, o1.long2, o1.long3, o1.long1Array, (int)o1.long3 * i, o2.long0Array[i], o2.long1, o2.long2, o2.long3, o2.long1Array, (int)o2.long3 * i), null, null, null, null, null);
    }

    @Override
    int valueSize(GenericKey state) {
        return 3 + GeometryArrayType.arrayKeySize(state, 8 + GeometryType.dimensions(state) * 8);
    }

    @Override
    void copyValue(GenericKey to, GenericKey from, int length) {
        this.initializeArray(to, length, null);
        System.arraycopy(from.long0Array, 0, to.long0Array, 0, length);
        to.long1 = from.long1;
        to.long2 = from.long2;
        to.long3 = from.long3;
        int dimensions = GeometryType.dimensions(from);
        to.long1Array = GeometryArrayType.ensureBigEnough(to.long1Array, dimensions * length);
        System.arraycopy(from.long1Array, 0, to.long1Array, 0, dimensions * length);
        to.spaceFillingCurve = from.spaceFillingCurve;
    }

    @Override
    void initializeArray(GenericKey key, int length, ValueWriter.ArrayType arrayType) {
        key.long0Array = GeometryArrayType.ensureBigEnough(key.long0Array, length);
        if (length == 0 && key.long1Array == null) {
            key.long1Array = PrimitiveLongCollections.EMPTY_LONG_ARRAY;
        }
    }

    @Override
    Value asValue(GenericKey state) {
        Point[] points = new Point[state.arrayLength];
        if (points.length > 0) {
            GeometryType.assertHasCoordinates(state);
            CoordinateReferenceSystem crs = CoordinateReferenceSystem.get((int)((int)state.long1), (int)((int)state.long2));
            int dimensions = GeometryType.dimensions(state);
            for (int i = 0; i < points.length; ++i) {
                points[i] = GeometryType.asValue(state, crs, dimensions * i);
            }
        }
        return Values.pointArray((Point[])points);
    }

    @Override
    void putValue(PageCursor cursor, GenericKey state) {
        GeometryType.putCrs(cursor, state.long1, state.long2, state.long3);
        int dimensions = GeometryType.dimensions(state);
        GeometryArrayType.putArray(cursor, state, (c, k, i) -> GeometryType.putPoint(c, k.long0Array[i], k.long3, k.long1Array, i * dimensions));
    }

    @Override
    boolean readValue(PageCursor cursor, int size, GenericKey into) {
        GeometryType.readCrs(cursor, into);
        return GeometryArrayType.readArray(cursor, ValueWriter.ArrayType.POINT, GeometryArrayType::readGeometryArrayItem, into);
    }

    @Override
    String toString(GenericKey state) {
        String asValueString = GeometryType.hasCoordinates(state) ? this.asValue(state).toString() : "NO_COORDINATES";
        return String.format("GeometryArray[tableId:%d, code:%d, rawValues:%s, value:%s]", state.long1, state.long2, Arrays.toString(Arrays.copyOf(state.long0Array, state.arrayLength)), asValueString);
    }

    private static boolean readGeometryArrayItem(PageCursor cursor, GenericKey into) {
        into.long0Array[into.currentArrayOffset] = cursor.getLong();
        int dimensions = GeometryType.dimensions(into);
        if (into.currentArrayOffset == 0) {
            into.long1Array = GeometryArrayType.ensureBigEnough(into.long1Array, dimensions * into.arrayLength);
        }
        int offset = into.currentArrayOffset * dimensions;
        for (int i = 0; i < dimensions; ++i) {
            into.long1Array[offset + i] = cursor.getLong();
        }
        ++into.currentArrayOffset;
        return true;
    }

    static void write(GenericKey state, int offset, long derivedSpaceFillingCurveValue, double[] coordinates) {
        state.long0Array[offset] = derivedSpaceFillingCurveValue;
        if (offset == 0) {
            int dimensions = coordinates.length;
            state.long1Array = GeometryArrayType.ensureBigEnough(state.long1Array, dimensions * state.arrayLength);
            state.long3 = dimensions;
        }
        int base = GeometryType.dimensions(state) * offset;
        for (int i = 0; i < coordinates.length; ++i) {
            state.long1Array[base + i] = Double.doubleToLongBits(coordinates[i]);
        }
    }

    @Override
    protected void addTypeSpecificDetails(StringJoiner joiner, GenericKey state) {
        joiner.add("long1=" + state.long1);
        joiner.add("long2=" + state.long2);
        joiner.add("long3=" + state.long3);
        joiner.add("long0Array=" + Arrays.toString(state.long0Array));
        joiner.add("long1Array=" + Arrays.toString(state.long1Array));
        super.addTypeSpecificDetails(joiner, state);
    }
}

