/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.query;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import org.neo4j.kernel.api.query.LookupIndexUsage;
import org.neo4j.kernel.api.query.RelationshipTypeIndexUsage;
import org.neo4j.kernel.api.query.SchemaIndexUsage;

public class CompilerInfo {
    private final String planner;
    private final String runtime;
    private final List<SchemaIndexUsage> indexes;
    private final List<RelationshipTypeIndexUsage> relationshipTypeIndexes;
    private final List<LookupIndexUsage> lookupIndexes;

    public CompilerInfo(@Nonnull String planner, @Nonnull String runtime, @Nonnull List<SchemaIndexUsage> indexes, @Nonnull List<RelationshipTypeIndexUsage> relationshipTypeIndexes, @Nonnull List<LookupIndexUsage> lookupIndexes) {
        this.planner = planner;
        this.runtime = runtime;
        this.indexes = indexes;
        this.relationshipTypeIndexes = relationshipTypeIndexes;
        this.lookupIndexes = lookupIndexes;
    }

    public CompilerInfo(@Nonnull String planner, @Nonnull String runtime, @Nonnull List<SchemaIndexUsage> indexes) {
        this(planner, runtime, indexes, Collections.emptyList(), Collections.emptyList());
    }

    public String planner() {
        return this.planner.toLowerCase(Locale.ROOT);
    }

    public String runtime() {
        return this.runtime.toLowerCase();
    }

    public List<SchemaIndexUsage> indexes() {
        return this.indexes;
    }

    public List<RelationshipTypeIndexUsage> relationshipTypeIndexes() {
        return this.relationshipTypeIndexes;
    }

    public List<LookupIndexUsage> lookupIndexes() {
        return this.lookupIndexes;
    }
}

