/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaState;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.api.index.IndexMapReference;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.IndexProxyCreator;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingController;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingControllerFactory;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.logging.LogProvider;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;

public final class IndexingServiceFactory {
    private IndexingServiceFactory() {
    }

    public static IndexingService createIndexingService(Config config, JobScheduler scheduler, IndexProviderMap providerMap, IndexStoreView storeView, TokenNameLookup tokenNameLookup, Iterable<IndexDescriptor> indexRules, LogProvider internalLogProvider, LogProvider userLogProvider, IndexingService.Monitor monitor, SchemaState schemaState, IndexStatisticsStore indexStatisticsStore, PageCacheTracer pageCacheTracer, MemoryTracker memoryTracker, String databaseName, boolean readOnly) {
        IndexSamplingConfig samplingConfig = new IndexSamplingConfig(config);
        IndexMapReference indexMapRef = new IndexMapReference();
        IndexSamplingControllerFactory factory = new IndexSamplingControllerFactory(samplingConfig, indexStatisticsStore, scheduler, tokenNameLookup, internalLogProvider, pageCacheTracer, databaseName);
        IndexSamplingController indexSamplingController = factory.create(indexMapRef);
        IndexProxyCreator proxySetup = new IndexProxyCreator(samplingConfig, indexStatisticsStore, providerMap, tokenNameLookup, internalLogProvider);
        return new IndexingService(proxySetup, providerMap, indexMapRef, storeView, indexRules, indexSamplingController, tokenNameLookup, scheduler, schemaState, internalLogProvider, userLogProvider, monitor, indexStatisticsStore, pageCacheTracer, memoryTracker, databaseName, readOnly);
    }
}

