/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import org.neo4j.kernel.impl.transaction.log.LogPosition;

public class RecoveryStartInformation {
    static final RecoveryStartInformation NO_RECOVERY_REQUIRED = new RecoveryStartInformation(LogPosition.UNSPECIFIED, LogPosition.UNSPECIFIED, -1L);
    static final RecoveryStartInformation MISSING_LOGS = new RecoveryStartInformation(null, null, -1L, true);
    private final long firstTxIdAfterLastCheckPoint;
    private final LogPosition transactionLogPosition;
    private final LogPosition checkpointPosition;
    private final boolean missingLogs;

    public RecoveryStartInformation(LogPosition transactionLogPosition, LogPosition checkpointPosition, long firstTxIdAfterLastCheckPoint) {
        this(transactionLogPosition, checkpointPosition, firstTxIdAfterLastCheckPoint, false);
    }

    private RecoveryStartInformation(LogPosition transactionLogPosition, LogPosition checkpointPosition, long firstTxIdAfterLastCheckPoint, boolean missingLogs) {
        this.firstTxIdAfterLastCheckPoint = firstTxIdAfterLastCheckPoint;
        this.transactionLogPosition = transactionLogPosition;
        this.checkpointPosition = checkpointPosition;
        this.missingLogs = missingLogs;
    }

    public boolean isRecoveryRequired() {
        return this.transactionLogPosition != LogPosition.UNSPECIFIED;
    }

    long getFirstTxIdAfterLastCheckPoint() {
        return this.firstTxIdAfterLastCheckPoint;
    }

    LogPosition getTransactionLogPosition() {
        return this.transactionLogPosition;
    }

    public LogPosition getCheckpointPosition() {
        return this.checkpointPosition;
    }

    boolean isMissingLogs() {
        return this.missingLogs;
    }
}

