/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseManager;
import org.neo4j.dbms.database.DbmsRuntimeVersion;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.util.Preconditions;
import org.neo4j.util.VisibleForTesting;

public abstract class DbmsRuntimeRepository {
    public static final DbmsRuntimeVersion LATEST_VERSION = DbmsRuntimeVersion.V4_2;
    public static final DbmsRuntimeVersion PREVIOUS_VERSION = DbmsRuntimeVersion.V4_1;
    public static final Label DBMS_RUNTIME_LABEL = Label.label((String)"DbmsRuntime");
    public static final String VERSION_PROPERTY = "version";
    private final DatabaseManager<?> databaseManager;
    private volatile DbmsRuntimeVersion currentVersion;

    protected DbmsRuntimeRepository(DatabaseManager<?> databaseManager) {
        this.databaseManager = databaseManager;
    }

    protected void fetchStateFromSystemDatabase() {
        GraphDatabaseService systemDatabase = this.getSystemDb();
        try (Transaction tx = systemDatabase.beginTx();
             ResourceIterator nodes = tx.findNodes(DBMS_RUNTIME_LABEL);){
            if (nodes.hasNext()) {
                this.currentVersion = DbmsRuntimeVersion.fromVersionNumber((Integer)((Node)nodes.next()).getProperty(VERSION_PROPERTY));
                Preconditions.checkState((!nodes.hasNext() ? 1 : 0) != 0, (String)"More than one dbms-runtime node in system database");
            } else {
                this.currentVersion = this.getFallbackVersion();
            }
        }
    }

    protected abstract DbmsRuntimeVersion getFallbackVersion();

    protected GraphDatabaseService getSystemDb() {
        return ((DatabaseContext)this.databaseManager.getDatabaseContext(DatabaseIdRepository.NAMED_SYSTEM_DATABASE_ID).orElseThrow(() -> new RuntimeException("Failed to get System Database"))).databaseFacade();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbmsRuntimeVersion getVersion() {
        if (this.currentVersion == null) {
            DbmsRuntimeRepository dbmsRuntimeRepository = this;
            synchronized (dbmsRuntimeRepository) {
                if (this.currentVersion == null) {
                    this.fetchStateFromSystemDatabase();
                }
            }
        }
        return this.currentVersion;
    }

    @VisibleForTesting
    public void setVersion(DbmsRuntimeVersion newVersion) {
        this.currentVersion = newVersion;
    }
}

