/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.neo4j.io.layout.DatabaseFile;
import org.neo4j.io.layout.DatabaseLayout;

final class DatabaseFileHelper {
    private DatabaseFileHelper() {
    }

    static List<Path> filesToKeepOnTruncation(DatabaseLayout databaseLayout) {
        DatabaseFile[] filesToKeep = new DatabaseFile[]{DatabaseFile.PROPERTY_KEY_TOKEN_NAMES_STORE, DatabaseFile.PROPERTY_KEY_TOKEN_STORE, DatabaseFile.LABEL_TOKEN_NAMES_STORE, DatabaseFile.LABEL_TOKEN_STORE, DatabaseFile.RELATIONSHIP_TYPE_TOKEN_NAMES_STORE, DatabaseFile.RELATIONSHIP_TYPE_TOKEN_STORE, DatabaseFile.SCHEMA_STORE};
        return Arrays.stream(filesToKeep).flatMap(arg_0 -> ((DatabaseLayout)databaseLayout).allFiles(arg_0)).collect(Collectors.toList());
    }

    static List<Path> filesToDeleteOnTruncation(List<Path> filesToKeep, DatabaseLayout databaseLayout, Path[] transactionLogs) {
        ArrayList<Path> filesToDelete = new ArrayList<Path>();
        Collections.addAll(filesToDelete, databaseLayout.listDatabaseFiles(file -> !filesToKeep.contains(file)));
        Path transactionLogsDirectory = databaseLayout.getTransactionLogsDirectory();
        if (!transactionLogsDirectory.equals(databaseLayout.databaseDirectory()) && transactionLogs != null) {
            Collections.addAll(filesToDelete, transactionLogs);
        }
        return filesToDelete;
    }
}

