/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.internal.event;

import java.util.Collection;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.graphdb.event.TransactionEventListener;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.internal.event.EmptyTransactionData;
import org.neo4j.kernel.internal.event.GlobalTransactionEventListeners;
import org.neo4j.kernel.internal.event.TransactionListenersState;
import org.neo4j.kernel.internal.event.TxStateTransactionDataSnapshot;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;

public class DatabaseTransactionEventListeners {
    private final GlobalTransactionEventListeners globalTransactionEventListeners;
    private final GraphDatabaseFacade databaseFacade;
    private final String databaseName;

    public DatabaseTransactionEventListeners(GraphDatabaseFacade databaseFacade, GlobalTransactionEventListeners globalTransactionEventListeners, NamedDatabaseId namedDatabaseId) {
        this.databaseFacade = databaseFacade;
        this.globalTransactionEventListeners = globalTransactionEventListeners;
        this.databaseName = namedDatabaseId.name();
    }

    public TransactionListenersState beforeCommit(ReadableTransactionState state, KernelTransaction transaction, StorageReader storageReader) {
        Collection<TransactionEventListener<?>> eventListeners = this.globalTransactionEventListeners.getDatabaseTransactionEventListeners(this.databaseName);
        if (!this.canInvokeBeforeCommitListeners(eventListeners, state)) {
            return null;
        }
        TransactionData txData = state == null ? EmptyTransactionData.EMPTY_DATA : new TxStateTransactionDataSnapshot(state, storageReader, transaction);
        TransactionListenersState listenersStates = new TransactionListenersState(txData);
        for (TransactionEventListener<?> listener : eventListeners) {
            Object listenerState = null;
            try {
                listenerState = listener.beforeCommit(txData, (Transaction)transaction.internalTransaction(), (GraphDatabaseService)this.databaseFacade);
            }
            catch (Throwable t) {
                listenersStates.failed(t);
            }
            listenersStates.addListenerState(listener, listenerState);
        }
        return listenersStates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCommit(TransactionListenersState listeners) {
        if (listeners == null) {
            return;
        }
        TransactionData txData = listeners.getTxData();
        try {
            for (TransactionListenersState.ListenerState<?> listenerState : listeners.getStates()) {
                TransactionEventListener<?> listener = listenerState.getListener();
                listener.afterCommit(txData, listenerState.getState(), (GraphDatabaseService)this.databaseFacade);
            }
        }
        finally {
            if (txData instanceof TxStateTransactionDataSnapshot) {
                ((TxStateTransactionDataSnapshot)txData).close();
            }
        }
    }

    public void afterRollback(TransactionListenersState listenersState) {
        if (listenersState == null) {
            return;
        }
        TransactionData txData = listenersState.getTxData();
        for (TransactionListenersState.ListenerState<?> listenerState : listenersState.getStates()) {
            TransactionEventListener<?> listener = listenerState.getListener();
            listener.afterRollback(txData, listenerState.getState(), (GraphDatabaseService)this.databaseFacade);
        }
    }

    private boolean canInvokeBeforeCommitListeners(Collection<TransactionEventListener<?>> listeners, ReadableTransactionState state) {
        return !listeners.isEmpty() && this.canInvokeListenersWithTransactionState(state);
    }

    private boolean canInvokeListenersWithTransactionState(ReadableTransactionState state) {
        if (state == null) {
            return false;
        }
        if (state.hasDataChanges()) {
            return true;
        }
        return state.hasChanges() && "system".equals(this.databaseName);
    }
}

