/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.RelationshipTypeIndexCursor;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.impl.newapi.CursorPool;
import org.neo4j.kernel.impl.newapi.IndexCursor;
import org.neo4j.kernel.impl.newapi.Read;

public class DefaultRelationshipTypeIndexCursor
extends IndexCursor<IndexProgressor>
implements RelationshipTypeIndexCursor {
    private final CursorPool<DefaultRelationshipTypeIndexCursor> pool;
    private Read read;
    private long relationship;
    private int type;
    private LongIterator added;
    private LongSet removed;

    DefaultRelationshipTypeIndexCursor(CursorPool<DefaultRelationshipTypeIndexCursor> pool) {
        this.pool = pool;
        this.relationship = -1L;
    }

    public void relationship(RelationshipScanCursor cursor) {
        this.read.singleRelationship(this.relationship, cursor);
    }

    public void sourceNode(NodeCursor cursor) {
        throw new UnsupportedOperationException("We have not yet implemented tracking of the relationship end nodes in the relationship type index cursor.");
    }

    public void targetNode(NodeCursor cursor) {
        throw new UnsupportedOperationException("We have not yet implemented tracking of the relationship end nodes in the relationship type index cursor.");
    }

    public int type() {
        return this.type;
    }

    public long sourceNodeReference() {
        throw new UnsupportedOperationException("We have not yet implemented tracking of the relationship end nodes in the relationship type index cursor.");
    }

    public long targetNodeReference() {
        throw new UnsupportedOperationException("We have not yet implemented tracking of the relationship end nodes in the relationship type index cursor.");
    }

    public long relationshipReference() {
        return this.relationship;
    }

    public boolean next() {
        if (this.added != null && this.added.hasNext()) {
            this.relationship = this.added.next();
            if (this.tracer != null) {
                this.tracer.onRelationship(this.relationship);
            }
            return true;
        }
        boolean hasNext = this.innerNext();
        if (this.tracer != null && hasNext) {
            this.tracer.onRelationship(this.relationship);
        }
        return hasNext;
    }

    public void closeInternal() {
        if (!this.isClosed()) {
            this.closeProgressor();
            this.relationship = -1L;
            this.type = Math.toIntExact(-1L);
            this.read = null;
            this.added = null;
            this.removed = null;
            this.pool.accept(this);
        }
    }

    public boolean isClosed() {
        return this.isProgressorClosed();
    }

    public float score() {
        return Float.NaN;
    }

    public void setRead(Read read) {
        this.read = read;
    }

    IndexProgressor.EntityTokenClient relationshipTypeClient() {
        return (reference, tokens) -> {
            if (this.isRemoved(reference)) {
                return false;
            }
            this.relationship = reference;
            return true;
        };
    }

    public void scan(IndexProgressor progressor, int type) {
        super.initialize(progressor);
        if (this.read.hasTxStateWithChanges()) {
            this.added = this.read.txState().relationshipsWithTypeChanged(type).getAdded().freeze().longIterator();
            this.removed = this.read.txState().addedAndRemovedRelationships().getRemoved().freeze();
        }
        this.type = type;
        if (this.tracer != null) {
            this.tracer.onRelationshipTypeScan(type);
        }
    }

    public void release() {
    }

    private boolean isRemoved(long reference) {
        return this.removed != null && this.removed.contains(reference);
    }
}

