/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.neo4j.common.Validator;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;

public final class Validators {
    public static final Validator<String> REGEX_FILE_EXISTS = fileWithRegexInName -> {
        File file = new File((String)fileWithRegexInName);
        File parent = file.getParentFile();
        if (parent == null) {
            throw new IllegalArgumentException("Directory of " + fileWithRegexInName + " doesn't exist");
        }
        if (Validators.matchingFiles(parent.toPath(), file.getName()).isEmpty()) {
            throw new IllegalArgumentException("File '" + file + "' doesn't exist");
        }
    };
    public static final Validator<Path> CONTAINS_EXISTING_DATABASE = dbDir -> {
        try (DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();){
            if (!Validators.isExistingDatabase((FileSystemAbstraction)fileSystem, DatabaseLayout.ofFlat((Path)dbDir))) {
                throw new IllegalArgumentException("Directory '" + dbDir + "' does not contain a database");
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    };

    private Validators() {
    }

    static List<Path> matchingFiles(Path directory, String fileWithRegexInName) {
        if (Files.notExists(directory, new LinkOption[0]) || !Files.isDirectory(directory, new LinkOption[0])) {
            throw new IllegalArgumentException(directory + " is not a directory");
        }
        Pattern pattern = Pattern.compile(fileWithRegexInName);
        ArrayList<Path> files = new ArrayList<Path>();
        try (DirectoryStream<Path> paths = Files.newDirectoryStream(directory);){
            for (Path path : paths) {
                if (!pattern.matcher(path.getFileName().toString()).matches()) continue;
                files.add(path);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return files;
    }

    public static boolean isExistingDatabase(FileSystemAbstraction fileSystem, DatabaseLayout layout) {
        return fileSystem.fileExists(layout.metadataStore());
    }

    public static <T> Validator<T> emptyValidator() {
        return value -> {};
    }
}

