/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import org.neo4j.internal.helpers.collection.NumberAwareStringComparator;
import org.neo4j.kernel.impl.util.Validators;

public class Converters {
    private static final Comparator<Path> BY_FILE_NAME = Comparator.comparing(Path::getFileName);
    private static final Comparator<Path> BY_FILE_NAME_WITH_CLEVER_NUMBERS = (o1, o2) -> NumberAwareStringComparator.INSTANCE.compare(o1.toAbsolutePath().toString(), o2.toAbsolutePath().toString());

    private Converters() {
    }

    public static <T> Function<String, T> optional() {
        return from -> null;
    }

    public static Function<String, Path[]> regexFiles(boolean cleverNumberRegexSort) {
        return name -> {
            Comparator<Path> sorting = cleverNumberRegexSort ? BY_FILE_NAME_WITH_CLEVER_NUMBERS : BY_FILE_NAME;
            File file = new File((String)name);
            File parent = file.getParentFile();
            if (parent == null) {
                throw new IllegalArgumentException("Directory of " + name + " doesn't exist");
            }
            List<Path> files = Validators.matchingFiles(parent.toPath(), file.getName());
            files.sort(sorting);
            return files.toArray(new Path[0]);
        };
    }

    public static Function<String, Path[]> toFiles(String delimiter, Function<String, Path[]> eachFileConverter) {
        return from -> {
            if (from == null) {
                return new Path[0];
            }
            String[] names = from.split(delimiter);
            ArrayList<Path> files = new ArrayList<Path>();
            for (String name : names) {
                files.addAll(Arrays.asList((Path[])eachFileConverter.apply(name)));
            }
            return files.toArray(new Path[0]);
        };
    }
}

