/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.collection;

import org.neo4j.collection.trackable.HeapTrackingLongObjectHashMap;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.values.storable.Value;

public class HeapTrackingValuesMap
extends HeapTrackingLongObjectHashMap<Value> {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(HeapTrackingValuesMap.class);
    private long valuesHeapSize;

    static HeapTrackingValuesMap createValuesMap(MemoryTracker memoryTracker) {
        memoryTracker.allocateHeap(SHALLOW_SIZE + HeapTrackingValuesMap.arraysHeapSize((int)16));
        return new HeapTrackingValuesMap(memoryTracker, 16);
    }

    private HeapTrackingValuesMap(MemoryTracker memoryTracker, int trackedCapacity) {
        super(memoryTracker, trackedCapacity);
    }

    public Value put(long key, Value value) {
        this.allocate(value);
        Value old = (Value)super.put(key, (Object)value);
        if (old != null) {
            this.release(old);
        }
        return old;
    }

    public Value remove(long key) {
        Value remove = (Value)super.remove(key);
        if (remove != null) {
            this.release(remove);
        }
        return remove;
    }

    public void clear() {
        super.clear();
        this.memoryTracker.releaseHeap(this.valuesHeapSize);
        this.valuesHeapSize = 0L;
    }

    private void allocate(Value value) {
        long valueHeapSize = value.estimatedHeapUsage();
        this.valuesHeapSize += valueHeapSize;
        this.memoryTracker.allocateHeap(valueHeapSize);
    }

    private void release(Value old) {
        long oldHeapSize = old.estimatedHeapUsage();
        this.valuesHeapSize -= oldHeapSize;
        this.memoryTracker.releaseHeap(oldHeapSize);
    }
}

