/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import org.neo4j.graphdb.Resource;
import org.neo4j.internal.helpers.Format;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.database.DatabaseTracers;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointThreshold;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.StoreCopyCheckPointMutex;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruning;
import org.neo4j.kernel.impl.transaction.tracing.DatabaseTracer;
import org.neo4j.kernel.impl.transaction.tracing.LogCheckPointEvent;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.monitoring.Health;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.time.Stopwatch;

public class CheckPointerImpl
extends LifecycleAdapter
implements CheckPointer {
    private static final String CHECKPOINT_TAG = "checkpoint";
    private static final long NO_TRANSACTION_ID = -1L;
    private final TransactionAppender appender;
    private final TransactionIdStore transactionIdStore;
    private final CheckPointThreshold threshold;
    private final ForceOperation forceOperation;
    private final LogPruning logPruning;
    private final Health databaseHealth;
    private final IOLimiter ioLimiter;
    private final Log msgLog;
    private final DatabaseTracers tracers;
    private final StoreCopyCheckPointMutex mutex;
    private volatile long lastCheckPointedTx;

    public CheckPointerImpl(TransactionIdStore transactionIdStore, CheckPointThreshold threshold, ForceOperation forceOperation, LogPruning logPruning, TransactionAppender appender, Health databaseHealth, LogProvider logProvider, DatabaseTracers tracers, IOLimiter ioLimiter, StoreCopyCheckPointMutex mutex) {
        this.appender = appender;
        this.transactionIdStore = transactionIdStore;
        this.threshold = threshold;
        this.forceOperation = forceOperation;
        this.logPruning = logPruning;
        this.databaseHealth = databaseHealth;
        this.ioLimiter = ioLimiter;
        this.msgLog = logProvider.getLog(CheckPointerImpl.class);
        this.tracers = tracers;
        this.mutex = mutex;
    }

    public void start() {
        this.threshold.initialize(this.transactionIdStore.getLastClosedTransactionId());
    }

    @Override
    public long forceCheckPoint(TriggerInfo info) throws IOException {
        this.ioLimiter.disableLimit();
        try {
            long l;
            block9: {
                Resource lock = this.mutex.checkPoint();
                try {
                    l = this.doCheckPoint(info);
                    if (lock == null) break block9;
                }
                catch (Throwable throwable) {
                    if (lock != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                lock.close();
            }
            return l;
        }
        finally {
            this.ioLimiter.enableLimit();
        }
    }

    @Override
    public long tryCheckPoint(TriggerInfo info) throws IOException {
        return this.tryCheckPoint(info, () -> false);
    }

    @Override
    public long tryCheckPointNoWait(TriggerInfo info) throws IOException {
        return this.tryCheckPoint(info, () -> true);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public long tryCheckPoint(TriggerInfo info, BooleanSupplier timeout) throws IOException {
        block20: {
            block19: {
                this.ioLimiter.disableLimit();
                lockAttempt = this.mutex.tryCheckPoint();
                if (lockAttempt != null) {
                    lock = lockAttempt;
                    try {
                        var5_6 = this.doCheckPoint(info);
                        return var5_6;
                    }
                    finally {
                        if (lock != null) {
                            lock.close();
                        }
                    }
                }
                lock = this.mutex.tryCheckPoint(timeout);
                if (lock == null) ** GOTO lbl-1000
                this.msgLog.info(info.describe(this.lastCheckPointedTx) + " Check pointing was already running, completed now");
                var5_8 = this.lastCheckPointedTx;
                if (lock == null) break block19;
                {
                    catch (Throwable var5_10) {
                        if (lock != null) {
                            try {
                                lock.close();
                            }
                            catch (Throwable var6_12) {
                                var5_10.addSuppressed(var6_12);
                            }
                        }
                        throw var5_10;
                    }
                }
                lock.close();
            }
            return var5_8;
lbl-1000:
            // 1 sources

            {
                var5_9 = -1L;
                if (lock == null) break block20;
                lock.close();
            }
        }
        return var5_9;
        finally {
            this.ioLimiter.enableLimit();
        }
    }

    @Override
    public long checkPointIfNeeded(TriggerInfo info) throws IOException {
        long[] lastClosedTransaction = this.transactionIdStore.getLastClosedTransaction();
        if (this.threshold.isCheckPointingNeeded(lastClosedTransaction[0], lastClosedTransaction[1], info)) {
            try (Resource lock = this.mutex.checkPoint();){
                long l = this.doCheckPoint(info);
                return l;
            }
        }
        return -1L;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private long doCheckPoint(TriggerInfo triggerInfo) throws IOException {
        DatabaseTracer databaseTracer = this.tracers.getDatabaseTracer();
        PageCacheTracer pageCacheTracer = this.tracers.getPageCacheTracer();
        try (PageCursorTracer cursorTracer = pageCacheTracer.createPageCursorTracer(CHECKPOINT_TAG);){
            LogCheckPointEvent event = databaseTracer.beginCheckPoint();
            try {
                long[] lastClosedTransaction = this.transactionIdStore.getLastClosedTransaction();
                long lastClosedTransactionId = lastClosedTransaction[0];
                LogPosition logPosition = new LogPosition(lastClosedTransaction[1], lastClosedTransaction[2]);
                String prefix = triggerInfo.describe(lastClosedTransactionId);
                this.databaseHealth.assertHealthy(IOException.class);
                this.msgLog.info(prefix + " checkpoint started...");
                Stopwatch startTime = Stopwatch.start();
                this.forceOperation.flushAndForce(this.ioLimiter, cursorTracer);
                this.databaseHealth.assertHealthy(IOException.class);
                this.appender.checkPoint(logPosition, event);
                this.threshold.checkPointHappened(lastClosedTransactionId);
                long durationMillis = startTime.elapsed(TimeUnit.MILLISECONDS);
                this.msgLog.info(prefix + " checkpoint completed in " + Format.duration((long)durationMillis));
                event.checkpointCompleted(durationMillis);
                this.logPruning.pruneLogs(logPosition.getLogVersion());
                this.lastCheckPointedTx = lastClosedTransactionId;
                long l = lastClosedTransactionId;
                if (event != null) {
                    event.close();
                }
                return l;
            }
            catch (Throwable throwable) {
                if (event != null) {
                    try {
                        event.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (Throwable t) {
            this.msgLog.error("Checkpoint failed", t);
            throw t;
        }
    }

    @Override
    public long lastCheckPointedTransactionId() {
        return this.lastCheckPointedTx;
    }

    public static interface ForceOperation {
        public void flushAndForce(IOLimiter var1, PageCursorTracer var2) throws IOException;
    }
}

